/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.cds;

import com.ibm.oti.shared.HelperAlreadyDefinedException;
import com.ibm.oti.shared.Shared;
import com.ibm.oti.shared.SharedClassHelperFactory;
import com.ibm.oti.shared.SharedClassURLHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.cds.CDSBundleFile;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.hookregistry.BundleFileWrapperFactoryHook;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.classpath.FragmentClasspath;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.BundleInfo;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.BundleFileWrapperChain;

public class CDSHookImpls
extends ClassLoaderHook
implements BundleFileWrapperFactoryHook {
    private static SharedClassHelperFactory factory = Shared.getSharedClassHelperFactory();

    private static CDSBundleFile getCDSBundleFile(BundleFile bundleFile) {
        CDSBundleFile cdsBundleFile = null;
        if (bundleFile instanceof BundleFileWrapperChain) {
            BundleFile wrapped = null;
            do {
                if ((wrapped = ((BundleFileWrapperChain)bundleFile).getWrapped()) instanceof CDSBundleFile) {
                    cdsBundleFile = (CDSBundleFile)wrapped;
                    break;
                }
                bundleFile = ((BundleFileWrapperChain)bundleFile).getNext();
            } while (wrapped != null);
        }
        return cdsBundleFile;
    }

    @Override
    public void recordClassDefine(String name, Class<?> clazz, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        if (clazz == null || !this.hasMagicClassNumber(classbytes) || CDSHookImpls.getCDSBundleFile(classpathEntry.getBundleFile()) == null) {
            return;
        }
        try {
            byte[] originalClassBytes = entry.getBytes();
            if (originalClassBytes != classbytes) {
                boolean modified = false;
                modified = originalClassBytes.length == classbytes.length ? !Arrays.equals(classbytes, originalClassBytes) : true;
                if (modified) {
                    return;
                }
            }
        }
        catch (IOException iOException) {
            return;
        }
        CDSBundleFile cdsFile = CDSHookImpls.getCDSBundleFile(classpathEntry.getBundleFile());
        if (cdsFile.getURL() == null) {
            return;
        }
        SharedClassURLHelper urlHelper = cdsFile.getURLHelper();
        if (urlHelper == null) {
            CDSBundleFile hostBundleFile = CDSHookImpls.getCDSBundleFile(manager.getGeneration().getBundleFile());
            if (hostBundleFile != null) {
                urlHelper = hostBundleFile.getURLHelper();
            }
            if (urlHelper != null) {
                cdsFile.setURLHelper(urlHelper);
            }
        }
        if (urlHelper != null) {
            urlHelper.storeSharedClass(null, cdsFile.getURL(), clazz);
            cdsFile.setPrimed(true);
        }
    }

    private boolean hasMagicClassNumber(byte[] classbytes) {
        if (classbytes == null || classbytes.length < 4) {
            return false;
        }
        return (classbytes[0] & 0xCA) == 202 && (classbytes[1] & 0xFE) == 254 && (classbytes[2] & 0xBA) == 186 && (classbytes[3] & 0xBE) == 190;
    }

    @Override
    public void classLoaderCreated(ModuleClassLoader classLoader) {
        if (factory == null) {
            return;
        }
        try {
            SharedClassURLHelper urlHelper = factory.getURLHelper((ClassLoader)classLoader);
            boolean minimizeUpdateChecks = urlHelper.setMinimizeUpdateChecks();
            CDSBundleFile hostFile = CDSHookImpls.getCDSBundleFile(classLoader.getClasspathManager().getGeneration().getBundleFile());
            if (hostFile != null) {
                hostFile.setURLHelper(urlHelper);
                if (minimizeUpdateChecks) {
                    hostFile.setPrimed(true);
                }
            }
            ClasspathManager cpManager = classLoader.getClasspathManager();
            Object[] objectArray = cpManager.getHostClasspathEntries();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClasspathEntry entry = objectArray[n2];
                CDSBundleFile cdsBundleFile = CDSHookImpls.getCDSBundleFile(entry.getBundleFile());
                if (cdsBundleFile != null) {
                    cdsBundleFile.setURLHelper(urlHelper);
                    if (minimizeUpdateChecks) {
                        cdsBundleFile.setPrimed(true);
                    }
                }
                ++n2;
            }
            objectArray = cpManager.getFragmentClasspaths();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object fragCP = objectArray[n2];
                ClasspathEntry[] classpathEntryArray = ((FragmentClasspath)fragCP).getEntries();
                int n3 = classpathEntryArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ClasspathEntry entry = classpathEntryArray[n4];
                    CDSBundleFile cdsBundleFile = CDSHookImpls.getCDSBundleFile(entry.getBundleFile());
                    if (cdsBundleFile != null) {
                        cdsBundleFile.setURLHelper(urlHelper);
                        if (minimizeUpdateChecks) {
                            cdsBundleFile.setPrimed(true);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (HelperAlreadyDefinedException helperAlreadyDefinedException) {}
    }

    @Override
    public boolean addClassPathEntry(ArrayList<ClasspathEntry> cpEntries, String cp, ClasspathManager hostmanager, BundleInfo.Generation sourceGeneration) {
        CDSBundleFile sourceFile;
        CDSBundleFile hostFile = CDSHookImpls.getCDSBundleFile(hostmanager.getGeneration().getBundleFile());
        if (hostFile != (sourceFile = CDSHookImpls.getCDSBundleFile(sourceGeneration.getBundleFile())) && hostFile != null && sourceFile != null) {
            SharedClassURLHelper urlHelper = hostFile.getURLHelper();
            sourceFile.setURLHelper(urlHelper);
            sourceFile.setPrimed(hostFile.getPrimed());
        }
        return false;
    }

    @Override
    public BundleFileWrapper wrapBundleFile(BundleFile bundleFile, BundleInfo.Generation generation, boolean base) {
        CDSBundleFile newBundleFile;
        if (!base && generation.getBundleInfo().getBundleId() != 0L) {
            SharedClassURLHelper urlHelper = null;
            BundleFile baseFile = generation.getBundleFile();
            if ((baseFile = CDSHookImpls.getCDSBundleFile(baseFile)) != null) {
                urlHelper = ((CDSBundleFile)baseFile).getURLHelper();
            }
            newBundleFile = new CDSBundleFile(bundleFile, urlHelper);
        } else {
            newBundleFile = new CDSBundleFile(bundleFile);
        }
        return newBundleFile;
    }

    void registerHooks(HookRegistry hookRegistry) {
        if (!Shared.isSharingEnabled()) {
            return;
        }
        hookRegistry.addClassLoaderHook(this);
        hookRegistry.addBundleFileWrapperFactoryHook(this);
    }
}

