/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.log;

import java.security.AccessController;
import java.security.Permission;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.forge.roaster._shade.org.eclipse.equinox.log.ExtendedLogService;
import org.jboss.forge.roaster._shade.org.eclipse.equinox.log.LogPermission;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.framework.util.SecureAction;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.log.ExtendedLogReaderServiceFactory;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.log.ExtendedLogServiceImpl;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.log.LoggerContextTargetMap;
import org.jboss.forge.roaster._shade.org.osgi.framework.Bundle;
import org.jboss.forge.roaster._shade.org.osgi.framework.BundleEvent;
import org.jboss.forge.roaster._shade.org.osgi.framework.BundleListener;
import org.jboss.forge.roaster._shade.org.osgi.framework.ServiceFactory;
import org.jboss.forge.roaster._shade.org.osgi.framework.ServiceReference;
import org.jboss.forge.roaster._shade.org.osgi.framework.ServiceRegistration;
import org.jboss.forge.roaster._shade.org.osgi.service.log.LogLevel;
import org.jboss.forge.roaster._shade.org.osgi.service.log.admin.LoggerAdmin;
import org.jboss.forge.roaster._shade.org.osgi.service.log.admin.LoggerContext;

public class ExtendedLogServiceFactory
implements ServiceFactory<ExtendedLogService>,
BundleListener {
    static final SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    final ReentrantReadWriteLock contextsLock = new ReentrantReadWriteLock();
    final LoggerContextTargetMap loggerContextTargetMap = new LoggerContextTargetMap();
    private final Permission logPermission = new LogPermission("*", "log");
    final ExtendedLogReaderServiceFactory logReaderServiceFactory;
    private final LoggerAdmin loggerAdmin = new EquinoxLoggerAdmin();

    public ExtendedLogServiceFactory(ExtendedLogReaderServiceFactory logReaderServiceFactory) {
        this.logReaderServiceFactory = logReaderServiceFactory;
    }

    @Override
    public ExtendedLogServiceImpl getService(Bundle bundle, ServiceRegistration<ExtendedLogService> registration) {
        return this.getLogService(bundle);
    }

    @Override
    public void ungetService(Bundle bundle, ServiceRegistration<ExtendedLogService> registration, ExtendedLogService service) {
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 16) {
            this.removeLogService(event.getBundle());
        }
    }

    ExtendedLogServiceImpl getLogService(Bundle bundle) {
        this.contextsLock.writeLock().lock();
        try {
            ExtendedLogServiceImpl extendedLogServiceImpl = this.loggerContextTargetMap.getLogService(bundle, this);
            return extendedLogServiceImpl;
        }
        finally {
            this.contextsLock.writeLock().unlock();
        }
    }

    void shutdown() {
        this.contextsLock.writeLock().lock();
        try {
            this.loggerContextTargetMap.clear();
        }
        finally {
            this.contextsLock.writeLock().unlock();
        }
    }

    void removeLogService(Bundle bundle) {
        this.contextsLock.writeLock().lock();
        try {
            this.loggerContextTargetMap.remove(bundle);
        }
        finally {
            this.contextsLock.writeLock().unlock();
        }
    }

    boolean isLoggable(Bundle bundle, String name, int level) {
        return this.logReaderServiceFactory.isLoggable(bundle, name, level);
    }

    void log(Bundle bundle, String name, StackTraceElement stackTraceElement, Object context, LogLevel logLevelEnum, int level, String message, ServiceReference<?> ref, Throwable exception) {
        this.logReaderServiceFactory.log(bundle, name, stackTraceElement, context, logLevelEnum, level, message, ref, exception);
    }

    void checkLogPermission() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(this.logPermission);
        }
    }

    EquinoxLoggerContext createEquinoxLoggerContext(String name) {
        return new EquinoxLoggerContext(name);
    }

    LoggerAdmin getLoggerAdmin() {
        return this.loggerAdmin;
    }

    class EquinoxLoggerAdmin
    implements LoggerAdmin {
        EquinoxLoggerAdmin() {
        }

        @Override
        public LoggerContext getLoggerContext(String name) {
            ExtendedLogServiceFactory.this.contextsLock.writeLock().lock();
            try {
                LoggerContext loggerContext = ExtendedLogServiceFactory.this.loggerContextTargetMap.createLoggerContext(name, ExtendedLogServiceFactory.this);
                return loggerContext;
            }
            finally {
                ExtendedLogServiceFactory.this.contextsLock.writeLock().unlock();
            }
        }
    }

    class EquinoxLoggerContext
    implements LoggerContext {
        final String contextName;
        final Map<String, LogLevel> contextLogLevels = new HashMap<String, LogLevel>();

        EquinoxLoggerContext(String name) {
            this.contextName = name;
        }

        @Override
        public String getName() {
            return this.contextName;
        }

        @Override
        public LogLevel getEffectiveLogLevel(String name) {
            ExtendedLogServiceFactory.this.contextsLock.readLock().lock();
            try {
                EquinoxLoggerContext rootContext;
                LogLevel level = null;
                String lookupName = name;
                while ((level = this.contextLogLevels.get(lookupName)) == null) {
                    int lastDot = lookupName.lastIndexOf(46);
                    if (lastDot < 0) break;
                    lookupName = lookupName.substring(0, lastDot);
                }
                if (level == null) {
                    level = this.contextLogLevels.get("ROOT");
                }
                if (level == null && this.contextName != null && (rootContext = ExtendedLogServiceFactory.this.loggerContextTargetMap.getRootLoggerContext()) != null) {
                    level = rootContext.getEffectiveLogLevel(name);
                }
                if (level == null) {
                    level = ExtendedLogServiceFactory.this.logReaderServiceFactory.getDefaultLogLevel();
                }
                LogLevel logLevel = level;
                return logLevel;
            }
            finally {
                ExtendedLogServiceFactory.this.contextsLock.readLock().unlock();
            }
        }

        @Override
        public Map<String, LogLevel> getLogLevels() {
            ExtendedLogServiceFactory.this.contextsLock.readLock().lock();
            try {
                HashMap<String, LogLevel> hashMap = new HashMap<String, LogLevel>(this.contextLogLevels);
                return hashMap;
            }
            finally {
                ExtendedLogServiceFactory.this.contextsLock.readLock().unlock();
            }
        }

        @Override
        public void setLogLevels(Map<String, LogLevel> logLevels) {
            boolean readLocked = false;
            try {
                ExtendedLogServiceFactory.this.contextsLock.writeLock().lock();
                try {
                    this.contextLogLevels.clear();
                    this.contextLogLevels.putAll(logLevels);
                    ExtendedLogServiceFactory.this.contextsLock.readLock().lock();
                    readLocked = true;
                }
                finally {
                    ExtendedLogServiceFactory.this.contextsLock.writeLock().unlock();
                }
                ExtendedLogServiceFactory.this.loggerContextTargetMap.applyLogLevels(this);
            }
            finally {
                if (readLocked) {
                    ExtendedLogServiceFactory.this.contextsLock.readLock().unlock();
                }
            }
        }

        @Override
        public void clear() {
            this.setLogLevels(Collections.emptyMap());
        }

        @Override
        public boolean isEmpty() {
            ExtendedLogServiceFactory.this.contextsLock.readLock().lock();
            try {
                boolean bl = this.contextLogLevels.isEmpty();
                return bl;
            }
            finally {
                ExtendedLogServiceFactory.this.contextsLock.readLock().unlock();
            }
        }
    }
}

