/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.serviceregistry;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.debug.Debug;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework.BundleContextImpl;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.messages.Msg;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.serviceregistry.ServiceFactoryUse;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;
import org.jboss.forge.roaster._shade.org.osgi.framework.ServiceException;

public class PrototypeServiceFactoryUse<S>
extends ServiceFactoryUse<S> {
    private final Map<S, AtomicInteger> serviceObjects = new IdentityHashMap<S, AtomicInteger>();

    PrototypeServiceFactoryUse(BundleContextImpl context, ServiceRegistrationImpl<S> registration) {
        super(context, registration);
    }

    @Override
    S newServiceObject() {
        Object service;
        assert (Thread.holdsLock(this));
        if (this.debug.DEBUG_SERVICES) {
            Debug.println("getServiceObject[factory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
        }
        if ((service = this.factoryGetService()) == null) {
            return null;
        }
        AtomicInteger useCount = this.serviceObjects.get(service);
        if (useCount == null) {
            this.serviceObjects.put(service, new AtomicInteger(1));
        } else if (useCount.getAndIncrement() == Integer.MAX_VALUE) {
            useCount.getAndDecrement();
            throw new ServiceException(Msg.SERVICE_USE_OVERFLOW);
        }
        return service;
    }

    @Override
    boolean releaseServiceObject(S service) {
        AtomicInteger useCount;
        assert (Thread.holdsLock(this));
        if (service == null || !this.serviceObjects.containsKey(service)) {
            throw new IllegalArgumentException(Msg.SERVICE_OBJECTS_UNGET_ARGUMENT_EXCEPTION);
        }
        if (this.debug.DEBUG_SERVICES) {
            Debug.println("ungetService[factory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
        }
        if ((useCount = this.serviceObjects.get(service)).decrementAndGet() < 1) {
            this.serviceObjects.remove(service);
            this.factoryUngetService(service);
        }
        return true;
    }

    @Override
    void release() {
        super.release();
        for (S service : this.serviceObjects.keySet()) {
            if (this.debug.DEBUG_SERVICES) {
                Debug.println("releaseService[factory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
            }
            this.factoryUngetService(service);
        }
        this.serviceObjects.clear();
    }

    @Override
    boolean isEmpty() {
        return super.isEmpty() && this.serviceObjects.isEmpty();
    }
}

