/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.core.internal.runtime;

import java.util.ArrayList;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.runtime.RuntimeLog;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.CoreException;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IStatus;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.MultiStatus;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.Status;
import org.jboss.forge.roaster._shade.org.eclipse.equinox.log.ExtendedLogEntry;
import org.jboss.forge.roaster._shade.org.eclipse.equinox.log.ExtendedLogService;
import org.jboss.forge.roaster._shade.org.eclipse.equinox.log.LogFilter;
import org.jboss.forge.roaster._shade.org.eclipse.equinox.log.Logger;
import org.jboss.forge.roaster._shade.org.eclipse.equinox.log.SynchronousLogListener;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.jboss.forge.roaster._shade.org.osgi.framework.Bundle;
import org.jboss.forge.roaster._shade.org.osgi.service.log.LogEntry;
import org.jboss.forge.roaster._shade.org.osgi.service.packageadmin.PackageAdmin;

public class PlatformLogWriter
implements SynchronousLogListener,
LogFilter {
    public static final String EQUINOX_LOGGER_NAME = "org.jboss.forge.roaster._shade.org.eclipse.equinox.logger";
    private final ExtendedLogService logService;
    private final PackageAdmin packageAdmin;
    private final Bundle bundle;

    public PlatformLogWriter(ExtendedLogService logService, PackageAdmin packageAdmin, Bundle bundle) {
        this.logService = logService;
        this.packageAdmin = packageAdmin;
        this.bundle = bundle;
    }

    void logging(IStatus status) {
        Bundle b = this.getBundle(status);
        Logger equinoxLog = this.logService.getLogger(b, EQUINOX_LOGGER_NAME);
        equinoxLog.log(PlatformLogWriter.getLog(status), PlatformLogWriter.getLevel(status), status.getMessage(), status.getException());
    }

    public static int getLevel(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 0: {
                return 4;
            }
        }
        return 32;
    }

    public static FrameworkLogEntry getLog(IStatus status) {
        IStatus[] children;
        IStatus coreStatus;
        int stackCode;
        Throwable t = status.getException();
        ArrayList<FrameworkLogEntry> childlist = new ArrayList<FrameworkLogEntry>();
        int n = stackCode = t instanceof CoreException ? 1 : 0;
        if (stackCode == 1 && (coreStatus = ((CoreException)t).getStatus()) != null) {
            childlist.add(PlatformLogWriter.getLog(coreStatus));
        }
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = children = status.getChildren();
            int n2 = children.length;
            int n3 = 0;
            while (n3 < n2) {
                IStatus child = iStatusArray[n3];
                childlist.add(PlatformLogWriter.getLog(child));
                ++n3;
            }
        }
        children = childlist.size() == 0 ? null : childlist.toArray(new FrameworkLogEntry[childlist.size()]);
        return new FrameworkLogEntry(status, status.getPlugin(), status.getSeverity(), status.getCode(), status.getMessage(), stackCode, t, (FrameworkLogEntry[])children);
    }

    private Bundle getBundle(IStatus status) {
        String pluginID = status.getPlugin();
        if (pluginID == null) {
            return this.bundle;
        }
        Bundle[] bundles = this.packageAdmin.getBundles(pluginID, null);
        return bundles == null || bundles.length == 0 ? this.bundle : bundles[0];
    }

    @Override
    public boolean isLoggable(Bundle bundle, String loggerName, int logLevel) {
        return EQUINOX_LOGGER_NAME.equals(loggerName) && RuntimeLog.hasListeners();
    }

    @Override
    public void logged(LogEntry entry) {
        RuntimeLog.logToListeners(PlatformLogWriter.convertToStatus(entry));
    }

    public static IStatus convertToStatus(LogEntry logEntry) {
        Object context = null;
        if (logEntry instanceof ExtendedLogEntry) {
            context = ((ExtendedLogEntry)logEntry).getContext();
        }
        if (context instanceof IStatus) {
            return (IStatus)context;
        }
        if (context instanceof FrameworkLogEntry) {
            FrameworkLogEntry fLogEntry = (FrameworkLogEntry)context;
            if ((context = fLogEntry.getContext()) instanceof IStatus) {
                return (IStatus)context;
            }
            return PlatformLogWriter.convertToStatus(fLogEntry);
        }
        return PlatformLogWriter.convertRawEntryToStatus(logEntry);
    }

    private static IStatus convertToStatus(FrameworkLogEntry entry) {
        FrameworkLogEntry[] children = entry.getChildren();
        if (children != null) {
            IStatus[] statusChildren = new Status[children.length];
            int i = 0;
            while (i < statusChildren.length) {
                statusChildren[i] = PlatformLogWriter.convertToStatus(children[i]);
                ++i;
            }
            return new MultiStatus(entry.getEntry(), entry.getBundleCode(), statusChildren, entry.getMessage(), entry.getThrowable());
        }
        return new Status(entry.getSeverity(), entry.getEntry(), entry.getBundleCode(), entry.getMessage(), entry.getThrowable());
    }

    private static IStatus convertRawEntryToStatus(LogEntry logEntry) {
        int severity;
        switch (logEntry.getLogLevel()) {
            case ERROR: {
                severity = 4;
                break;
            }
            case WARN: {
                severity = 2;
                break;
            }
            case INFO: {
                severity = 1;
                break;
            }
            case AUDIT: 
            case DEBUG: 
            case TRACE: {
                severity = 0;
                break;
            }
            default: {
                severity = -1;
            }
        }
        Bundle bundle = logEntry.getBundle();
        return new Status(severity, bundle == null ? null : bundle.getSymbolicName(), logEntry.getMessage(), logEntry.getException());
    }
}

