/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core;

import org.jboss.forge.roaster._shade.org.eclipse.core.resources.ResourcesPlugin;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IJavaElement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.JavaModelException;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.ClasspathChange;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.ClasspathValidation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.DeltaProcessingState;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.ExternalFolderChange;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaElementDelta;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaModelManager;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaModelOperation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaProject;

public abstract class ChangeClasspathOperation
extends JavaModelOperation {
    protected boolean canChangeResources;

    public ChangeClasspathOperation(IJavaElement[] elements, boolean canChangeResources) {
        super(elements);
        this.canChangeResources = canChangeResources;
    }

    @Override
    protected boolean canModifyRoots() {
        return true;
    }

    protected void classpathChanged(ClasspathChange change, boolean refreshExternalFolder) throws JavaModelException {
        JavaProject project = change.project;
        project.resetCaches();
        if (this.canChangeResources) {
            if (this.isTopLevelOperation() && !ResourcesPlugin.getWorkspace().isTreeLocked()) {
                new ClasspathValidation(project).validate();
            }
            project.getProject().clearCachedDynamicReferences();
            new ExternalFolderChange(project, change.oldResolvedClasspath).updateExternalFoldersIfNecessary(refreshExternalFolder, null);
        } else {
            DeltaProcessingState state = JavaModelManager.getDeltaState();
            JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
            int result = change.generateDelta(delta, true);
            if ((result & 1) != 0) {
                this.addDelta(delta);
                state.rootsAreStale = true;
                change.requestIndexing();
                state.addClasspathValidation(project);
            }
            if ((result & 2) != 0) {
                project.getProject().clearCachedDynamicReferences();
                state.addProjectReferenceChange(project);
            }
            if ((result & 4) != 0) {
                state.addExternalFolderChange(project, change.oldResolvedClasspath);
            }
        }
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return !this.canChangeResources;
    }
}

