/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.dom.util;

import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AST;

public class DOMASTUtil {
    private static boolean isNodeTypeSupportedinAST(AST ast, int nodeType) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast.apiLevel(), ast.isPreviewEnabledSet(), nodeType);
    }

    private static boolean isNodeTypeSupportedinAST(int apiLevel, boolean previewEnabled, int nodeType) {
        switch (nodeType) {
            case 100: 
            case 101: {
                return apiLevel >= 14;
            }
            case 62: 
            case 102: 
            case 103: {
                return DOMASTUtil.isPreviewEnabled(apiLevel, previewEnabled);
            }
        }
        return false;
    }

    private static boolean isPreviewEnabled(int apiLevel, boolean previewEnabled) {
        return apiLevel == 14 && previewEnabled;
    }

    public static boolean isSwitchExpressionSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 100);
    }

    public static boolean isYieldStatementSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 101);
    }

    public static boolean isTextBlockSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 102);
    }

    public static boolean isRecordDeclarationSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 103);
    }

    public static boolean isRecordDeclarationSupported(int apiLevel, boolean previewEnabled) {
        return DOMASTUtil.isNodeTypeSupportedinAST(apiLevel, previewEnabled, 103);
    }

    public static boolean isInstanceofExpressionPatternSupported(AST ast) {
        return DOMASTUtil.isNodeTypeSupportedinAST(ast, 62);
    }

    public static boolean isInstanceofExpressionPatternSupported(int apiLevel, boolean previewEnabled) {
        return DOMASTUtil.isNodeTypeSupportedinAST(apiLevel, previewEnabled, 62);
    }

    public static void checkASTLevel(int level) {
        switch (level) {
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return;
            }
        }
        throw new IllegalArgumentException();
    }
}

