/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.field;

import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.Nd;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.db.Database;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.db.ModificationLog;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.field.BaseField;

public class FieldPointer
extends BaseField {
    private final ModificationLog.Tag putTag;

    public FieldPointer(String structName, int fieldNumber) {
        this.setFieldName("field " + fieldNumber + ", a " + this.getClass().getSimpleName() + " in struct " + structName);
        this.putTag = ModificationLog.createTag("Writing " + this.getFieldName());
    }

    public long get(Nd nd, long address) {
        Database db = nd.getDB();
        return db.getRecPtr(address + (long)this.offset);
    }

    public void put(Nd nd, long address, long newValue) {
        Database db = nd.getDB();
        db.getLog().start(this.putTag);
        try {
            nd.getDB().putRecPtr(address + (long)this.offset, newValue);
        }
        finally {
            db.getLog().end(this.putTag);
        }
    }

    @Override
    public int getRecordSize() {
        return 4;
    }
}

