/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java;

import java.util.List;
import java.util.function.Supplier;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.DatabaseRef;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.IReader;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.Nd;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.JavaIndex;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdResourceFile;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdType;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.nd.java.NdTypeId;

public final class TypeRef
implements Supplier<NdType> {
    final DatabaseRef<NdType> ref;
    final char[] fileName;
    final char[] fieldDescriptor;
    final TypeSupplier typeSupplier = new TypeSupplier();

    private TypeRef(NdType type) {
        this.fieldDescriptor = type.getTypeId().getRawType().getFieldDescriptor().getChars();
        this.fileName = type.getResourceFile().getLocation().getChars();
        this.ref = new DatabaseRef<NdType>(type.getNd(), this.typeSupplier, type);
    }

    private TypeRef(Nd nd, char[] resourcePath, char[] fieldDescriptor) {
        this.fieldDescriptor = fieldDescriptor;
        this.fileName = resourcePath;
        this.ref = new DatabaseRef<NdType>(nd, this.typeSupplier);
    }

    public char[] getFieldDescriptor() {
        return this.fieldDescriptor;
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public static TypeRef create(NdType type) {
        return new TypeRef(type);
    }

    public static TypeRef create(Nd nd, char[] resourcePath, char[] fieldDescriptor) {
        return new TypeRef(nd, resourcePath, fieldDescriptor);
    }

    public IReader lock() {
        return this.ref.lock();
    }

    @Override
    public NdType get() {
        return (NdType)this.ref.get();
    }

    private final class TypeSupplier
    implements Supplier<NdType> {
        @Override
        public NdType get() {
            NdTypeId typeId = JavaIndex.getIndex(TypeRef.this.ref.getNd()).findType(TypeRef.this.fieldDescriptor);
            if (typeId == null) {
                return null;
            }
            List<NdType> implementations = typeId.getTypes();
            for (NdType next : implementations) {
                NdResourceFile nextResourceFile = next.getResourceFile();
                if (nextResourceFile.getLocation().compare(TypeRef.this.fileName, false) != 0 || !nextResourceFile.isDoneIndexing()) continue;
                return next;
            }
            return null;
        }
    }
}

