/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jface.text;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class MultiStringMatcher {
    private final Node root = new Node(0){

        @Override
        Node next(Character c) {
            Node child = super.next(c);
            return child == null ? this : child;
        }
    };

    public static Builder builder() {
        return new BuilderImpl();
    }

    private MultiStringMatcher() {
    }

    private void add(String ... searchStrings) {
        if (searchStrings != null) {
            String[] stringArray = searchStrings;
            int n = searchStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String searchString = stringArray[n2];
                if (searchString != null && !searchString.isEmpty()) {
                    Node node = this.root;
                    char[] cArray = searchString.toCharArray();
                    int n3 = cArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        char c = cArray[n4];
                        node = node.add(c);
                        ++n4;
                    }
                    node.match = searchString;
                }
                ++n2;
            }
        }
    }

    private void buildLinks() {
        LinkedList<Node> queue = new LinkedList<Node>();
        for (Node s : this.root.children.values()) {
            if (s.hasChildren()) {
                queue.add(s);
            }
            s.fail = this.root;
        }
        while (!queue.isEmpty()) {
            Node r = (Node)queue.remove(0);
            for (Map.Entry<Character, Node> entry : r.children.entrySet()) {
                Node f;
                Character c = entry.getKey();
                Node s = entry.getValue();
                if (s.hasChildren()) {
                    queue.add(s);
                }
                Node state = r.fail;
                while ((f = state.next(c)) == null) {
                    state = state.fail;
                }
                s.fail = f;
                if (f.match != null) {
                    s.output = f;
                    continue;
                }
                if (f.output == null) continue;
                s.output = f.output;
            }
        }
    }

    public void find(CharSequence text, int offset, Consumer<Match> matches) {
        int textEnd = text.length();
        Node node = this.root;
        int i = offset;
        while (i < textEnd) {
            Node next;
            Character c = Character.valueOf(text.charAt(i));
            while ((next = node.next(c)) == null) {
                node = node.fail;
            }
            node = next;
            if (node.match != null) {
                matches.accept(new MatchResult(node.match, i - node.depth + 1));
            }
            Node out = node.output;
            while (out != null) {
                matches.accept(new MatchResult(out.match, i - out.depth + 1));
                out = out.output;
            }
            ++i;
        }
    }

    public List<Match> find(CharSequence text, int offset) {
        LinkedList<Match> matches = new LinkedList<Match>();
        this.find(text, offset, matches::add);
        return matches;
    }

    public Match indexOf(CharSequence text, int offset) {
        int textEnd = text.length();
        MatchResult primaryMatch = null;
        MatchResult subMatch = null;
        Node node = this.root;
        int i = offset;
        while (i < textEnd) {
            Node out;
            Character c = Character.valueOf(text.charAt(i));
            Node next = node.next(c);
            if (next == null) {
                if (primaryMatch != null) {
                    return primaryMatch;
                }
                while ((next = (node = node.fail).next(c)) == null) {
                }
                if (subMatch != null) {
                    if (next == this.root) {
                        return subMatch;
                    }
                    if (subMatch.getOffset() < i - node.depth) {
                        return subMatch;
                    }
                }
            }
            node = next;
            if (node.match != null) {
                primaryMatch = new MatchResult(node.match, i - node.depth + 1);
                if (!node.hasChildren()) {
                    return primaryMatch;
                }
            }
            if (primaryMatch == null && (out = node.output) != null) {
                int newOffset = i - out.depth + 1;
                if (subMatch == null || newOffset < subMatch.getOffset() || newOffset == subMatch.getOffset() && out.depth > subMatch.getText().length()) {
                    subMatch = new MatchResult(out.match, newOffset);
                }
            }
            ++i;
        }
        return primaryMatch != null ? primaryMatch : subMatch;
    }

    public static Match indexOf(CharSequence text, int offset, String ... searchStrings) {
        return MultiStringMatcher.create(searchStrings).indexOf(text, offset);
    }

    public static MultiStringMatcher create(String ... searchStrings) {
        return MultiStringMatcher.builder().add(searchStrings).build();
    }

    /* synthetic */ MultiStringMatcher(MultiStringMatcher multiStringMatcher) {
        this();
    }

    /* synthetic */ MultiStringMatcher(MultiStringMatcher multiStringMatcher, MultiStringMatcher multiStringMatcher2) {
        this();
    }

    public static interface Builder {
        public Builder add(String ... var1);

        public MultiStringMatcher build();
    }

    private static class BuilderImpl
    implements Builder {
        private MultiStringMatcher m = new MultiStringMatcher(null);

        BuilderImpl() {
        }

        private void check() {
            if (this.m == null) {
                throw new IllegalStateException("Builder.build() was already called");
            }
        }

        @Override
        public Builder add(String ... searchStrings) {
            this.check();
            this.m.add(searchStrings);
            return this;
        }

        @Override
        public MultiStringMatcher build() {
            this.check();
            MultiStringMatcher result = this.m;
            this.m = null;
            if (!result.root.hasChildren()) {
                return new MultiStringMatcher(){

                    @Override
                    public void find(CharSequence text, int offset, Consumer<Match> matches) {
                    }

                    @Override
                    public Match indexOf(CharSequence text, int offset) {
                        return null;
                    }
                };
            }
            result.buildLinks();
            return result;
        }
    }

    public static interface Match {
        public String getText();

        public int getOffset();
    }

    private static class MatchResult
    implements Match {
        private final String match;
        private final int offset;

        public MatchResult(String match, int offset) {
            this.match = match;
            this.offset = offset;
        }

        @Override
        public String getText() {
            return this.match;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        public int hashCode() {
            return Objects.hashCode(this.match) * 31 + Integer.hashCode(this.offset);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MatchResult other = (MatchResult)obj;
            return this.offset == other.offset && Objects.equals(this.match, other.match);
        }

        public String toString() {
            return String.valueOf('[') + this.match + ", " + this.offset + ']';
        }
    }

    private static class Node {
        HashMap<Character, Node> children;
        String match;
        Node fail;
        Node output;
        final int depth;

        Node(int depth) {
            this.depth = depth;
        }

        Node next(Character c) {
            return this.children == null ? null : this.children.get(c);
        }

        Node add(char c) {
            if (this.children == null) {
                this.children = new HashMap();
            }
            return this.children.computeIfAbsent(Character.valueOf(c), key -> new Node(this.depth + 1));
        }

        boolean hasChildren() {
            return this.children != null;
        }

        public String toString() {
            return "[depth=" + this.depth + ", match=" + this.match + ", children=" + (this.children == null ? "<none>" : this.children.keySet().stream().map(c -> c.toString()).collect(Collectors.joining(", "))) + ']';
        }
    }
}

