/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.weaving;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.BundleLoader;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.weaving.WovenClassImpl;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.jboss.forge.roaster._shade.org.osgi.framework.Bundle;
import org.jboss.forge.roaster._shade.org.osgi.framework.ServiceRegistration;

public class WeavingHookConfigurator
extends ClassLoaderHook {
    private final Map<ServiceRegistration<?>, Boolean> blackList = Collections.synchronizedMap(new WeakHashMap());
    private final ThreadLocal<WovenClassContext> wovenClassContext = new ThreadLocal();
    private final EquinoxContainer container;

    public WeavingHookConfigurator(EquinoxContainer container) {
        this.container = container;
    }

    private ServiceRegistry getRegistry() {
        return this.container.getServiceRegistry();
    }

    @Override
    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        ServiceRegistry registry = this.getRegistry();
        if (registry == null) {
            return null;
        }
        ModuleClassLoader classLoader = manager.getClassLoader();
        BundleLoader loader = classLoader.getBundleLoader();
        WovenClassImpl wovenClass = new WovenClassImpl(name, classbytes, entry, classpathEntry, loader, this.container, this.blackList);
        WovenClassContext context = this.wovenClassContext.get();
        if (context == null) {
            context = new WovenClassContext();
            this.wovenClassContext.set(context);
        }
        context.wovenClassStack.add(wovenClass);
        if (!context.processClassNameStack.contains(name)) {
            context.processClassNameStack.add(name);
            try {
                byte[] byArray = wovenClass.callHooks();
                return byArray;
            }
            catch (Throwable t) {
                ServiceRegistration<?> errorHook = wovenClass.getErrorHook();
                Bundle errorBundle = errorHook != null ? errorHook.getReference().getBundle() : manager.getGeneration().getRevision().getBundle();
                this.container.getEventPublisher().publishFrameworkEvent(2, errorBundle, t);
                ClassFormatError error = new ClassFormatError("Unexpected error from weaving hook.");
                error.initCause(t);
                throw error;
            }
            finally {
                context.processClassNameStack.remove(name);
            }
        }
        return null;
    }

    @Override
    public void recordClassDefine(String name, Class<?> clazz, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        WovenClassContext context = this.wovenClassContext.get();
        if (context == null || context.wovenClassStack.size() == 0) {
            return;
        }
        WovenClassImpl wovenClass = context.wovenClassStack.remove(context.wovenClassStack.size() - 1);
        wovenClass.setWeavingCompleted(clazz);
    }

    @Override
    public boolean isProcessClassRecursionSupported() {
        return true;
    }

    static class WovenClassContext {
        List<WovenClassImpl> wovenClassStack = new ArrayList<WovenClassImpl>(6);
        List<String> processClassNameStack = new ArrayList<String>(6);

        WovenClassContext() {
        }
    }
}

