/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.container.ModuleRevision;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.debug.Debug;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.messages.Msg;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.BundleInfo;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.MRUBundleFileList;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.util.NLS;
import org.jboss.forge.roaster._shade.org.osgi.framework.FrameworkListener;

public abstract class CloseableBundleFile<E>
extends BundleFile {
    private final ReentrantLock openLock = new ReentrantLock();
    private final Condition refCondition = this.openLock.newCondition();
    private final MRUBundleFileList mruList;
    protected final BundleInfo.Generation generation;
    protected final Debug debug;
    private volatile boolean closed = true;
    private int referenceCount = 0;

    public CloseableBundleFile(File basefile, BundleInfo.Generation generation, MRUBundleFileList mruList, Debug debug) {
        super(basefile);
        this.debug = debug;
        this.generation = generation;
        this.closed = true;
        this.mruList = mruList;
    }

    private boolean lockOpen() {
        try {
            this.open(true);
            return true;
        }
        catch (IOException e) {
            ModuleRevision r;
            if (this.generation != null && (r = this.generation.getRevision()) != null) {
                ModuleContainerAdaptor.ContainerEvent eventType = ModuleContainerAdaptor.ContainerEvent.ERROR;
                if (!r.getRevisions().getModuleRevisions().contains(r)) {
                    eventType = ModuleContainerAdaptor.ContainerEvent.INFO;
                }
                this.generation.getBundleInfo().getStorage().getAdaptor().publishContainerEvent(eventType, r.getRevisions().getModule(), e, new FrameworkListener[0]);
            }
            return false;
        }
    }

    private void open(boolean keepLock) throws IOException {
        block12: {
            this.openLock.lock();
            try {
                if (this.closed) {
                    boolean needBackPressure = this.mruListAdd();
                    if (needBackPressure) {
                        this.openLock.unlock();
                        try {
                            this.mruListApplyBackPressure();
                        }
                        finally {
                            this.openLock.lock();
                        }
                    }
                    if (this.closed) {
                        if (needBackPressure) {
                            this.mruListAdd();
                        }
                        this.doOpen();
                        this.closed = false;
                    }
                    break block12;
                }
                this.mruListUse();
            }
            finally {
                if (!keepLock || this.closed) {
                    this.openLock.unlock();
                }
            }
        }
    }

    protected abstract void doOpen() throws IOException;

    File extractDirectory(String dirName) {
        if (!this.lockOpen()) {
            return null;
        }
        try {
            for (String path : this.getPaths()) {
                if (!path.startsWith(dirName) || path.endsWith("/")) continue;
                this.getFile(path, false);
            }
            File file = this.getExtractFile(dirName);
            return file;
        }
        finally {
            this.openLock.unlock();
        }
    }

    protected abstract Iterable<String> getPaths();

    private File getExtractFile(String entryName) {
        if (this.generation == null) {
            return null;
        }
        return this.generation.getExtractFile(".cp", entryName);
    }

    @Override
    public File getFile(String entry, boolean nativeCode) {
        if (!this.lockOpen()) {
            return null;
        }
        try {
            BundleEntry bEntry = this.getEntry(entry);
            if (bEntry == null) {
                return null;
            }
            File nested = this.getExtractFile(bEntry.getName());
            if (nested != null) {
                if (nested.exists()) {
                    if (this.debug.DEBUG_BUNDLE_FILE) {
                        Debug.println("File already present: " + nested.getPath());
                    }
                    if (nested.isDirectory()) {
                        this.extractDirectory(bEntry.getName());
                    }
                } else if (bEntry.getName().endsWith("/")) {
                    nested.mkdirs();
                    if (!nested.isDirectory()) {
                        if (this.debug.DEBUG_BUNDLE_FILE) {
                            Debug.println("Unable to create directory: " + nested.getPath());
                        }
                        throw new IOException(NLS.bind(Msg.ADAPTOR_DIRECTORY_CREATE_EXCEPTION, nested.getAbsolutePath()));
                    }
                    this.extractDirectory(bEntry.getName());
                } else {
                    InputStream in = bEntry.getInputStream();
                    if (in == null) {
                        return null;
                    }
                    this.generation.storeContent(nested, in, nativeCode);
                }
                File file = nested;
                return file;
            }
        }
        finally {
            this.openLock.unlock();
        }
        return null;
    }

    @Override
    public boolean containsDir(String dir) {
        if (!this.lockOpen()) {
            return false;
        }
        try {
            if (dir == null) {
                return false;
            }
            if (dir.length() == 0) {
                return true;
            }
            if (dir.charAt(0) == '/') {
                if (dir.length() == 1) {
                    return true;
                }
                dir = dir.substring(1);
            }
            if (dir.length() > 0 && dir.charAt(dir.length() - 1) != '/') {
                dir = String.valueOf(dir) + '/';
            }
            for (String entry : this.getPaths()) {
                if (!entry.startsWith(dir)) continue;
                return true;
            }
        }
        finally {
            this.openLock.unlock();
        }
        return false;
    }

    @Override
    public BundleEntry getEntry(String path) {
        if (!this.lockOpen()) {
            return null;
        }
        try {
            BundleEntry bundleEntry = this.findEntry(path);
            return bundleEntry;
        }
        finally {
            this.openLock.unlock();
        }
    }

    protected abstract BundleEntry findEntry(String var1);

    @Override
    public Enumeration<String> getEntryPaths(String path, boolean recurse) {
        if (!this.lockOpen()) {
            return null;
        }
        try {
            if (path == null) {
                throw new NullPointerException();
            }
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
                path = path + "/";
            }
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (String entryPath : this.getPaths()) {
                if (!entryPath.startsWith(path) || path.length() >= entryPath.length()) continue;
                this.getEntryPaths(path, entryPath.substring(path.length()), recurse, result);
            }
            Enumeration<String> enumeration = result.size() == 0 ? null : Collections.enumeration(result);
            return enumeration;
        }
        finally {
            this.openLock.unlock();
        }
    }

    private void getEntryPaths(String path, String entry, boolean recurse, LinkedHashSet<String> entries) {
        if (entry.length() == 0) {
            return;
        }
        int slash = entry.indexOf(47);
        if (slash == -1) {
            entries.add(String.valueOf(path) + entry);
        } else {
            path = String.valueOf(path) + entry.substring(0, slash + 1);
            entries.add(path);
            if (recurse) {
                this.getEntryPaths(path, entry.substring(slash + 1), true, entries);
            }
        }
    }

    @Override
    public void close() throws IOException {
        block8: {
            this.openLock.lock();
            try {
                if (this.closed) break block8;
                if (this.referenceCount > 0 && this.isMruListClosing()) {
                    try {
                        this.refCondition.await(1000L, TimeUnit.MICROSECONDS);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.referenceCount != 0 || this.closed) {
                        return;
                    }
                }
                this.closed = true;
                this.doClose();
                this.mruListRemove();
                this.postClose();
            }
            finally {
                this.openLock.unlock();
            }
        }
    }

    protected abstract void doClose() throws IOException;

    protected abstract void postClose();

    private boolean isMruListClosing() {
        return this.mruList != null && this.mruList.isClosing(this);
    }

    private boolean isMruEnabled() {
        return this.mruList != null && this.mruList.isEnabled();
    }

    private void mruListRemove() {
        if (this.mruList != null) {
            this.mruList.remove(this);
        }
    }

    private void mruListUse() {
        if (this.mruList != null) {
            this.mruList.use(this);
        }
    }

    private void mruListApplyBackPressure() {
        if (this.mruList != null) {
            this.mruList.applyBackpressure();
        }
    }

    private boolean mruListAdd() {
        if (this.mruList != null) {
            return this.mruList.add(this);
        }
        return false;
    }

    @Override
    public void open() throws IOException {
        this.open(false);
    }

    void incrementReference() {
        this.openLock.lock();
        try {
            ++this.referenceCount;
        }
        finally {
            this.openLock.unlock();
        }
    }

    void decrementReference() {
        this.openLock.lock();
        try {
            this.referenceCount = Math.max(0, this.referenceCount - 1);
            if (this.referenceCount == 0) {
                this.refCondition.signal();
            }
        }
        finally {
            this.openLock.unlock();
        }
    }

    public InputStream getInputStream(E entry) throws IOException {
        if (!this.lockOpen()) {
            throw new IOException("Failed to lock bundle file.");
        }
        try {
            InputStream in = this.doGetInputStream(entry);
            if (this.isMruEnabled()) {
                in = new BundleEntryInputStream(in);
            }
            InputStream inputStream = in;
            return inputStream;
        }
        finally {
            this.openLock.unlock();
        }
    }

    protected abstract InputStream doGetInputStream(E var1) throws IOException;

    private class BundleEntryInputStream
    extends FilterInputStream {
        private boolean streamClosed;

        public BundleEntryInputStream(InputStream stream) {
            super(stream);
            this.streamClosed = false;
            CloseableBundleFile.this.incrementReference();
        }

        @Override
        public int available() throws IOException {
            try {
                return super.available();
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                try {
                    super.close();
                }
                catch (IOException e) {
                    throw this.enrichExceptionWithBaseFile(e);
                }
            }
            catch (Throwable throwable) {
                BundleEntryInputStream bundleEntryInputStream = this;
                synchronized (bundleEntryInputStream) {
                    if (this.streamClosed) {
                        return;
                    }
                    this.streamClosed = true;
                }
                CloseableBundleFile.this.decrementReference();
                throw throwable;
            }
            BundleEntryInputStream bundleEntryInputStream = this;
            synchronized (bundleEntryInputStream) {
                if (this.streamClosed) {
                    return;
                }
                this.streamClosed = true;
            }
            CloseableBundleFile.this.decrementReference();
        }

        @Override
        public int read() throws IOException {
            try {
                return super.read();
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        @Override
        public int read(byte[] var0, int var1, int var2) throws IOException {
            try {
                return super.read(var0, var1, var2);
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        @Override
        public int read(byte[] var0) throws IOException {
            try {
                return super.read(var0);
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        @Override
        public void reset() throws IOException {
            try {
                super.reset();
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        @Override
        public long skip(long var0) throws IOException {
            try {
                return super.skip(var0);
            }
            catch (IOException e) {
                throw this.enrichExceptionWithBaseFile(e);
            }
        }

        private IOException enrichExceptionWithBaseFile(IOException e) {
            return new IOException(CloseableBundleFile.this.getBaseFile().toString(), e);
        }
    }
}

