/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.osgi.framework;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.security.auth.x500.X500Principal;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework.FilterImpl;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.hookregistry.FrameworkUtilHelper;
import org.jboss.forge.roaster._shade.org.osgi.framework.Bundle;
import org.jboss.forge.roaster._shade.org.osgi.framework.BundleReference;
import org.jboss.forge.roaster._shade.org.osgi.framework.Filter;
import org.jboss.forge.roaster._shade.org.osgi.framework.InvalidSyntaxException;

public class FrameworkUtil {
    private static final List<FrameworkUtilHelper> helpers;

    static {
        ArrayList<FrameworkUtilHelper> l = new ArrayList<FrameworkUtilHelper>();
        try {
            ServiceLoader<FrameworkUtilHelper> helperLoader = AccessController.doPrivileged(new PrivilegedAction<ServiceLoader<FrameworkUtilHelper>>(){

                @Override
                public ServiceLoader<FrameworkUtilHelper> run() {
                    return ServiceLoader.load(FrameworkUtilHelper.class, FrameworkUtilHelper.class.getClassLoader());
                }
            });
            Iterator<FrameworkUtilHelper> iHelpers = helperLoader.iterator();
            while (iHelpers.hasNext()) {
                l.add(iHelpers.next());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        helpers = Collections.unmodifiableList(l);
    }

    private FrameworkUtil() {
    }

    public static Filter createFilter(String filter) throws InvalidSyntaxException {
        return FilterImpl.newInstance(filter);
    }

    public static boolean matchDistinguishedNameChain(String matchPattern, List<String> dnChain) {
        return DNChainMatching.match(matchPattern, dnChain);
    }

    public static Bundle getBundle(final Class<?> classFromBundle) {
        Object cl = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return classFromBundle.getClassLoader();
            }
        });
        if (cl instanceof BundleReference) {
            return ((BundleReference)cl).getBundle();
        }
        for (FrameworkUtilHelper helper : helpers) {
            Bundle b = helper.getBundle(classFromBundle);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    private static final class DNChainMatching {
        private static final String MINUS_WILDCARD = "-";
        private static final String STAR_WILDCARD = "*";

        private DNChainMatching() {
        }

        private static boolean rdnmatch(List<?> rdn, List<?> rdnPattern) {
            if (rdn.size() != rdnPattern.size()) {
                return false;
            }
            int i = 0;
            while (i < rdn.size()) {
                int patNameEnd;
                String rdnNameValue = (String)rdn.get(i);
                String patNameValue = (String)rdnPattern.get(i);
                int rdnNameEnd = rdnNameValue.indexOf(61);
                if (rdnNameEnd != (patNameEnd = patNameValue.indexOf(61)) || !rdnNameValue.regionMatches(0, patNameValue, 0, rdnNameEnd)) {
                    return false;
                }
                String patValue = patNameValue.substring(patNameEnd);
                String rdnValue = rdnNameValue.substring(rdnNameEnd);
                if (!(rdnValue.equals(patValue) || patValue.equals("=*") || patValue.equals("=#16012a"))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private static boolean dnmatch(List<?> dn, List<?> dnPattern) {
            int dnStart = 0;
            int patStart = 0;
            int patLen = dnPattern.size();
            if (patLen == 0) {
                return false;
            }
            if (dnPattern.get(0).equals(STAR_WILDCARD)) {
                patStart = 1;
                --patLen;
            }
            if (dn.size() < patLen) {
                return false;
            }
            if (dn.size() > patLen) {
                if (!dnPattern.get(0).equals(STAR_WILDCARD)) {
                    return false;
                }
                dnStart = dn.size() - patLen;
            }
            int i = 0;
            while (i < patLen) {
                if (!DNChainMatching.rdnmatch((List)dn.get(i + dnStart), (List)dnPattern.get(i + patStart))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        private static List<Object> parseDNchainPattern(String pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException("The pattern must not be null.");
            }
            ArrayList<Object> parsed = new ArrayList<Object>();
            int length = pattern.length();
            int c = 59;
            int startIndex = DNChainMatching.skipSpaces(pattern, 0);
            while (startIndex < length) {
                int cursor = startIndex;
                int endIndex = startIndex;
                boolean inQuote = false;
                block6: while (cursor < length) {
                    c = pattern.charAt(cursor);
                    switch (c) {
                        case 34: {
                            inQuote = !inQuote;
                            break;
                        }
                        case 92: {
                            if (++cursor != length) break;
                            throw new IllegalArgumentException("unterminated escape");
                        }
                        case 59: {
                            if (!inQuote) break block6;
                        }
                    }
                    if (c != 32) {
                        endIndex = cursor + 1;
                    }
                    ++cursor;
                }
                parsed.add(pattern.substring(startIndex, endIndex));
                startIndex = DNChainMatching.skipSpaces(pattern, cursor + 1);
            }
            if (c == 59) {
                throw new IllegalArgumentException("empty pattern");
            }
            int i = 0;
            while (i < parsed.size()) {
                String dn = (String)parsed.get(i);
                if (!dn.equals(STAR_WILDCARD) && !dn.equals(MINUS_WILDCARD)) {
                    ArrayList<Object> rdns = new ArrayList<Object>();
                    if (dn.charAt(0) == '*') {
                        int index = DNChainMatching.skipSpaces(dn, 1);
                        if (dn.charAt(index) != ',') {
                            throw new IllegalArgumentException("invalid wildcard prefix");
                        }
                        rdns.add(STAR_WILDCARD);
                        dn = new X500Principal(dn.substring(index + 1)).getName("CANONICAL");
                    } else {
                        dn = new X500Principal(dn).getName("CANONICAL");
                    }
                    DNChainMatching.parseDN(dn, rdns);
                    parsed.set(i, rdns);
                }
                ++i;
            }
            return parsed;
        }

        private static List<Object> parseDNchain(List<String> chain) {
            if (chain == null) {
                throw new IllegalArgumentException("DN chain must not be null.");
            }
            ArrayList<Object> result = new ArrayList<Object>(chain.size());
            for (String dn : chain) {
                dn = new X500Principal(dn).getName("CANONICAL");
                ArrayList<Object> rdns = new ArrayList<Object>();
                DNChainMatching.parseDN(dn, rdns);
                result.add(rdns);
            }
            if (result.size() == 0) {
                throw new IllegalArgumentException("empty DN chain");
            }
            return result;
        }

        private static int skipSpaces(String dnChain, int startIndex) {
            while (startIndex < dnChain.length() && dnChain.charAt(startIndex) == ' ') {
                ++startIndex;
            }
            return startIndex;
        }

        private static void parseDN(String dn, List<Object> rdn) {
            int startIndex = 0;
            char c = '\u0000';
            ArrayList<String> nameValues = new ArrayList<String>();
            while (startIndex < dn.length()) {
                int endIndex = startIndex;
                while (endIndex < dn.length()) {
                    c = dn.charAt(endIndex);
                    if (c == ',' || c == '+') break;
                    if (c == '\\') {
                        ++endIndex;
                    }
                    ++endIndex;
                }
                if (endIndex > dn.length()) {
                    throw new IllegalArgumentException("unterminated escape " + dn);
                }
                nameValues.add(dn.substring(startIndex, endIndex));
                if (c != '+') {
                    rdn.add(nameValues);
                    nameValues = endIndex != dn.length() ? new ArrayList() : null;
                }
                startIndex = endIndex + 1;
            }
            if (nameValues != null) {
                throw new IllegalArgumentException("improperly terminated DN " + dn);
            }
        }

        private static int skipWildCards(List<Object> dnChainPattern, int dnChainPatternIndex) {
            int i = dnChainPatternIndex;
            while (i < dnChainPattern.size()) {
                Object dnPattern = dnChainPattern.get(i);
                if (dnPattern instanceof String) {
                    if (!dnPattern.equals(STAR_WILDCARD) && !dnPattern.equals(MINUS_WILDCARD)) {
                        throw new IllegalArgumentException("expected wildcard in DN pattern");
                    }
                } else {
                    if (dnPattern instanceof List) break;
                    throw new IllegalArgumentException("expected String or List in DN Pattern");
                }
                ++i;
            }
            return i;
        }

        private static boolean dnChainMatch(List<Object> dnChain, int dnChainIndex, List<Object> dnChainPattern, int dnChainPatternIndex) throws IllegalArgumentException {
            if (dnChainIndex >= dnChain.size()) {
                return false;
            }
            if (dnChainPatternIndex >= dnChainPattern.size()) {
                return false;
            }
            Object dnPattern = dnChainPattern.get(dnChainPatternIndex);
            if (dnPattern instanceof String) {
                if (!dnPattern.equals(STAR_WILDCARD) && !dnPattern.equals(MINUS_WILDCARD)) {
                    throw new IllegalArgumentException("expected wildcard in DN pattern");
                }
                dnChainPatternIndex = dnPattern.equals(MINUS_WILDCARD) ? DNChainMatching.skipWildCards(dnChainPattern, dnChainPatternIndex) : ++dnChainPatternIndex;
                if (dnChainPatternIndex >= dnChainPattern.size()) {
                    return dnPattern.equals(MINUS_WILDCARD) ? true : dnChain.size() - 1 == dnChainIndex;
                }
                if (dnPattern.equals(STAR_WILDCARD)) {
                    return DNChainMatching.dnChainMatch(dnChain, dnChainIndex, dnChainPattern, dnChainPatternIndex) || DNChainMatching.dnChainMatch(dnChain, dnChainIndex + 1, dnChainPattern, dnChainPatternIndex);
                }
                int i = dnChainIndex;
                while (i < dnChain.size()) {
                    if (DNChainMatching.dnChainMatch(dnChain, i, dnChainPattern, dnChainPatternIndex)) {
                        return true;
                    }
                    ++i;
                }
            } else {
                if (dnPattern instanceof List) {
                    do {
                        if (!DNChainMatching.dnmatch((List)dnChain.get(dnChainIndex), (List)dnPattern)) {
                            return false;
                        }
                        if (++dnChainIndex >= dnChain.size() && ++dnChainPatternIndex >= dnChainPattern.size()) {
                            return true;
                        }
                        if (dnChainIndex >= dnChain.size()) {
                            return (dnChainPatternIndex = DNChainMatching.skipWildCards(dnChainPattern, dnChainPatternIndex)) >= dnChainPattern.size();
                        }
                        if (dnChainPatternIndex >= dnChainPattern.size()) {
                            return false;
                        }
                        dnPattern = dnChainPattern.get(dnChainPatternIndex);
                        if (!(dnPattern instanceof String)) continue;
                        if (!dnPattern.equals(STAR_WILDCARD) && !dnPattern.equals(MINUS_WILDCARD)) {
                            throw new IllegalArgumentException("expected wildcard in DN pattern");
                        }
                        return DNChainMatching.dnChainMatch(dnChain, dnChainIndex, dnChainPattern, dnChainPatternIndex);
                    } while (dnPattern instanceof List);
                    throw new IllegalArgumentException("expected String or List in DN Pattern");
                }
                throw new IllegalArgumentException("expected String or List in DN Pattern");
            }
            return false;
        }

        static boolean match(String pattern, List<String> dnChain) {
            List<Object> parsedDNPattern;
            List<Object> parsedDNChain;
            try {
                parsedDNChain = DNChainMatching.parseDNchain(dnChain);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Invalid DN chain: " + DNChainMatching.toString(dnChain), e);
            }
            try {
                parsedDNPattern = DNChainMatching.parseDNchainPattern(pattern);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Invalid match pattern: " + pattern, e);
            }
            return DNChainMatching.dnChainMatch(parsedDNChain, 0, parsedDNPattern, 0);
        }

        private static String toString(List<?> dnChain) {
            if (dnChain == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            Iterator<?> iChain = dnChain.iterator();
            while (iChain.hasNext()) {
                sb.append(iChain.next());
                if (!iChain.hasNext()) continue;
                sb.append("; ");
            }
            return sb.toString();
        }
    }
}

