/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.apache.commons.lang3.StringUtils;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.BodyDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.FieldDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.jboss.forge.roaster._shade.org.eclipse.jface.text.Document;
import org.jboss.forge.roaster.model.Field;
import org.jboss.forge.roaster.model.JavaInterface;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.Parameter;
import org.jboss.forge.roaster.model.Property;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.ast.MethodFinderVisitor;
import org.jboss.forge.roaster.model.impl.AbstractJavaSource;
import org.jboss.forge.roaster.model.impl.FieldImpl;
import org.jboss.forge.roaster.model.impl.JDTHelper;
import org.jboss.forge.roaster.model.impl.JavaInterfaceImpl;
import org.jboss.forge.roaster.model.impl.MethodImpl;
import org.jboss.forge.roaster.model.impl.PropertyImpl;
import org.jboss.forge.roaster.model.impl.TypeImpl;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.InterfaceCapableSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaInterfaceSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MemberSource;
import org.jboss.forge.roaster.model.source.MethodHolderSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;
import org.jboss.forge.roaster.model.source.PropertyHolderSource;
import org.jboss.forge.roaster.model.source.PropertySource;
import org.jboss.forge.roaster.model.util.Methods;
import org.jboss.forge.roaster.model.util.Types;

public abstract class AbstractJavaSourceMemberHolder<O extends JavaSource<O> & PropertyHolderSource<O>>
extends AbstractJavaSource<O>
implements InterfaceCapableSource<O>,
PropertyHolderSource<O> {
    private static final Pattern GET_SET_PATTERN = Pattern.compile("^[gs]et.+$");

    protected AbstractJavaSourceMemberHolder(JavaSource<?> enclosingType, Document document, CompilationUnit unit, BodyDeclaration declaration) {
        super(enclosingType, document, unit, declaration);
    }

    public FieldSource<O> addField() {
        FieldImpl<AbstractJavaSourceMemberHolder> field = new FieldImpl<AbstractJavaSourceMemberHolder>(this);
        this.addField((Field<O>)field);
        return field;
    }

    public FieldSource<O> addField(String declaration) {
        String stub = "public class Stub { " + declaration + " }";
        JavaClassSource temp = (JavaClassSource)Roaster.parse((String)stub);
        List fields = temp.getFields();
        FieldImpl<AbstractJavaSourceMemberHolder> result = null;
        for (FieldSource stubField : fields) {
            Object variableDeclaration = stubField.getInternal();
            FieldImpl<AbstractJavaSourceMemberHolder> field = new FieldImpl<AbstractJavaSourceMemberHolder>(this, variableDeclaration, true);
            this.addField((Field<O>)field);
            if (result != null) continue;
            result = field;
        }
        return result;
    }

    private void addField(Field<O> field) {
        List bodyDeclarations = this.getDeclaration().bodyDeclarations();
        int idx = 0;
        for (Object object : bodyDeclarations) {
            if (!(object instanceof FieldDeclaration)) break;
            ++idx;
        }
        bodyDeclarations.add(idx, ((VariableDeclarationFragment)field.getInternal()).getParent());
    }

    public List<MemberSource<O, ?>> getMembers() {
        ArrayList result = new ArrayList();
        result.addAll(this.getFields());
        result.addAll(this.getMethods());
        return result;
    }

    public List<FieldSource<O>> getFields() {
        ArrayList<FieldImpl<AbstractJavaSourceMemberHolder>> result = new ArrayList<FieldImpl<AbstractJavaSourceMemberHolder>>();
        List bodyDeclarations = this.getDeclaration().bodyDeclarations();
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (!(bodyDeclaration instanceof FieldDeclaration)) continue;
            FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
            List fragments = fieldDeclaration.fragments();
            for (VariableDeclarationFragment fragment : fragments) {
                result.add(new FieldImpl<AbstractJavaSourceMemberHolder>(this, fragment));
            }
        }
        return Collections.unmodifiableList(result);
    }

    public FieldSource<O> getField(String name) {
        for (FieldSource<O> field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public boolean hasField(String name) {
        for (FieldSource<O> field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasField(Field<O> field) {
        return this.getFields().contains(field);
    }

    public O removeField(Field<O> field) {
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)field.getInternal();
        Iterator declarationsIterator = this.getDeclaration().bodyDeclarations().iterator();
        while (declarationsIterator.hasNext()) {
            List fragments;
            FieldDeclaration declaration;
            Object next = declarationsIterator.next();
            if (!(next instanceof FieldDeclaration) || !(declaration = (FieldDeclaration)next).equals(fragment.getParent()) || !(fragments = declaration.fragments()).contains(fragment)) continue;
            if (fragments.size() == 1) {
                declarationsIterator.remove();
                break;
            }
            fragments.remove(fragment);
            break;
        }
        return (O)this;
    }

    public boolean hasMethod(Method<O, ?> method) {
        return this.getMethods().contains(method);
    }

    public boolean hasMethodSignature(String name) {
        return this.hasMethodSignature(name, new String[0]);
    }

    public boolean hasMethodSignature(String name, String ... paramTypes) {
        return this.getMethod(name, paramTypes) != null;
    }

    public boolean hasMethodSignature(String name, Class<?> ... paramTypes) {
        if (paramTypes == null) {
            paramTypes = new Class[]{};
        }
        String[] types = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            types[i] = paramTypes[i].getName();
        }
        return this.hasMethodSignature(name, types);
    }

    public MethodSource<O> getMethod(String name) {
        for (MethodSource<O> method : this.getMethods()) {
            if (!method.getName().equals(name) || method.getParameters().size() != 0) continue;
            return method;
        }
        return null;
    }

    public MethodSource<O> getMethod(String name, String ... paramTypes) {
        for (MethodSource<O> local : this.getMethods()) {
            if (!local.getName().equals(name)) continue;
            List localParams = local.getParameters();
            if (paramTypes == null || localParams.size() != paramTypes.length) continue;
            boolean matches = true;
            for (int i = 0; i < localParams.size(); ++i) {
                ParameterSource localParam = (ParameterSource)localParams.get(i);
                String type = paramTypes[i];
                if (Types.areEquivalent((String)localParam.getType().getName(), (String)type)) continue;
                matches = false;
            }
            if (!matches) continue;
            return local;
        }
        return null;
    }

    public MethodSource<O> getMethod(String name, Class<?> ... paramTypes) {
        if (paramTypes == null) {
            paramTypes = new Class[]{};
        }
        String[] types = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            types[i] = paramTypes[i].getName();
        }
        return this.getMethod(name, types);
    }

    public boolean hasMethodSignature(Method<?, ?> method) {
        for (MethodSource<O> local : this.getMethods()) {
            if (!local.getName().equals(method.getName())) continue;
            Iterator localParams = local.getParameters().iterator();
            for (Parameter methodParam : method.getParameters()) {
                if (localParams.hasNext() && Objects.equals(((ParameterSource)localParams.next()).getType().getName(), methodParam.getType().getName())) continue;
                return false;
            }
            return !localParams.hasNext();
        }
        return false;
    }

    public O removeMethod(Method<O, ?> method) {
        this.getDeclaration().bodyDeclarations().remove(method.getInternal());
        return (O)this;
    }

    public MethodSource<O> addMethod() {
        MethodImpl<AbstractJavaSourceMemberHolder> m = new MethodImpl<AbstractJavaSourceMemberHolder>(this);
        this.getDeclaration().bodyDeclarations().add(m.getInternal());
        return m;
    }

    public MethodSource<O> addMethod(String method) {
        MethodImpl<AbstractJavaSourceMemberHolder> m = new MethodImpl<AbstractJavaSourceMemberHolder>(this, method);
        this.getDeclaration().bodyDeclarations().add(m.getInternal());
        return m;
    }

    public MethodSource<O> addMethod(java.lang.reflect.Method method) {
        MethodImpl<AbstractJavaSourceMemberHolder> m = new MethodImpl<AbstractJavaSourceMemberHolder>(this, method);
        this.getDeclaration().bodyDeclarations().add(m.getInternal());
        return m;
    }

    public MethodSource<O> addMethod(Method<?, ?> method) {
        MethodImpl<AbstractJavaSourceMemberHolder> m = new MethodImpl<AbstractJavaSourceMemberHolder>(this, method.toString());
        this.getDeclaration().bodyDeclarations().add(m.getInternal());
        return m;
    }

    public List<MethodSource<O>> getMethods() {
        ArrayList<MethodImpl<AbstractJavaSourceMemberHolder>> result = new ArrayList<MethodImpl<AbstractJavaSourceMemberHolder>>();
        MethodFinderVisitor methodFinderVisitor = new MethodFinderVisitor();
        this.body.accept(methodFinderVisitor);
        List<MethodDeclaration> methods = methodFinderVisitor.getMethods();
        for (MethodDeclaration methodDeclaration : methods) {
            result.add(new MethodImpl<AbstractJavaSourceMemberHolder>(this, methodDeclaration));
        }
        return Collections.unmodifiableList(result);
    }

    public List<String> getInterfaces() {
        ArrayList<String> result = new ArrayList<String>();
        List<org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type> superTypes = JDTHelper.getInterfaces(this.getDeclaration());
        for (org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type type : superTypes) {
            String name = JDTHelper.getTypeName(type);
            String rawName = Types.stripGenerics((String)name);
            if (Types.isSimpleName((String)rawName)) {
                String pkg;
                Import imprt = this.getImport(rawName);
                if (imprt == null) {
                    imprt = this.getImport(this.resolveType(rawName));
                }
                if (!StringUtils.isEmpty(pkg = imprt != null ? imprt.getPackage() : this.getPackage())) {
                    name = pkg + "." + name;
                }
            }
            result.add(name);
        }
        return result;
    }

    public O addInterface(String type) {
        if (!this.hasInterface(type)) {
            String simpleName = Types.toSimpleName((String)type);
            org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type interfaceType = JDTHelper.getInterfaces(((JavaInterfaceImpl)Roaster.parse(JavaInterfaceImpl.class, (String)("public interface Mock extends " + simpleName + " {}"))).getDeclaration()).get(0);
            if (this.hasInterface(simpleName) || this.hasImport(simpleName)) {
                interfaceType = JDTHelper.getInterfaces(((JavaInterfaceImpl)Roaster.parse(JavaInterfaceImpl.class, (String)("public interface Mock extends " + type + " {}"))).getDeclaration()).get(0);
            }
            if (!this.hasImport(simpleName)) {
                this.addImport(type);
            }
            ASTNode node = ASTNode.copySubtree(this.unit.getAST(), interfaceType);
            JDTHelper.getInterfaces(this.getDeclaration()).add((org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type)node);
        }
        return (O)this;
    }

    public O addInterface(Class<?> type) {
        return this.addInterface(type.getCanonicalName());
    }

    public O implementInterface(Class<?> type) {
        O obj = this.addInterface(type);
        for (MethodSource methodSource : Methods.implementAbstractMethods(type, (MethodHolderSource)this)) {
            ((MethodSource)methodSource.setPublic()).addAnnotation(Override.class);
        }
        return obj;
    }

    public O implementInterface(JavaInterface<?> type) {
        O obj = this.addInterface(type);
        if (type instanceof JavaInterfaceSource) {
            HashSet<Import> usedImports = new HashSet<Import>();
            JavaInterfaceSource interfaceSource = (JavaInterfaceSource)type;
            for (MethodSource method : interfaceSource.getMethods()) {
                if (method.isDefault()) continue;
                if (!method.isReturnTypeVoid()) {
                    usedImports.add(interfaceSource.getImport(method.getReturnType().getQualifiedName()));
                }
                for (ParameterSource parameter : method.getParameters()) {
                    usedImports.add(interfaceSource.getImport(parameter.getType().getQualifiedName()));
                }
            }
            for (Import imprt : interfaceSource.getImports()) {
                if (!usedImports.contains(imprt)) continue;
                this.addImport(imprt);
            }
        }
        for (MethodSource methodSource : Methods.implementAbstractMethods(type, (MethodHolderSource)this)) {
            ((MethodSource)methodSource.setPublic()).addAnnotation(Override.class);
        }
        return obj;
    }

    public O addInterface(JavaInterface<?> type) {
        return this.addInterface(type.getQualifiedName());
    }

    public boolean hasInterface(String type) {
        for (String name : this.getInterfaces()) {
            if (!Types.areEquivalent((String)name, (String)type)) continue;
            return true;
        }
        return false;
    }

    public boolean hasInterface(Class<?> type) {
        return this.hasInterface(type.getCanonicalName());
    }

    public boolean hasInterface(JavaInterface<?> type) {
        return this.hasInterface(type.getQualifiedName());
    }

    public O removeInterface(String type) {
        List<org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type> interfaces = JDTHelper.getInterfaces(this.getDeclaration());
        for (org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type i : interfaces) {
            if (!Types.areEquivalent((String)i.toString(), (String)type)) continue;
            interfaces.remove(i);
            break;
        }
        return (O)this;
    }

    public O removeInterface(Class<?> type) {
        return this.removeInterface(type.getCanonicalName());
    }

    public O removeInterface(JavaInterface<?> type) {
        return this.removeInterface(type.getQualifiedName());
    }

    public final boolean hasProperty(String name) {
        return this.getProperty(name) != null;
    }

    public final boolean hasProperty(Property<O> property) {
        return this.getProperties().contains(property);
    }

    public final PropertySource<O> addProperty(String type, String name) {
        if (this.hasProperty(name)) {
            throw new IllegalStateException("Cannot create existing property " + name);
        }
        Object origin = this.getOrigin();
        if (origin.requiresImport(type)) {
            origin.addImport(type);
        }
        for (String genericType : Types.splitGenerics((String)type)) {
            if (!origin.requiresImport(genericType)) continue;
            origin.addImport(genericType);
        }
        final TypeImpl typeObject = new TypeImpl(this.getOrigin(), null, Types.toSimpleName((String)type));
        PropertyImpl result = new PropertyImpl<O>(name, (JavaSource)this.getOrigin()){

            @Override
            public Type<O> getType() {
                Type result = super.getType();
                return result == null ? typeObject : result;
            }
        };
        if (!this.isInterface()) {
            result.createField();
        }
        result.setAccessible(true);
        result.setMutable(!this.isEnum());
        return this.getProperty(name);
    }

    public PropertySource<O> addProperty(Class<?> type, String name) {
        return this.addProperty(type.getCanonicalName(), name);
    }

    public PropertySource<O> addProperty(JavaType<?> type, String name) {
        return this.addProperty(type.getQualifiedName(), name);
    }

    public final AbstractJavaSourceMemberHolder<O> removeProperty(Property<O> property) {
        if (this.hasProperty(property)) {
            this.getProperty(property.getName()).setMutable(false).setAccessible(false).removeField();
        }
        return this;
    }

    public final PropertySource<O> getProperty(String name) {
        Objects.requireNonNull(name, "name is null");
        PropertyImpl result = new PropertyImpl(name, this.getOrigin());
        return result.isValid() ? result : null;
    }

    public final List<PropertySource<O>> getProperties() {
        LinkedHashSet<String> propertyNames = new LinkedHashSet<String>();
        for (MethodSource<O> methodSource : this.getMethods()) {
            if (!this.isAccessor((Method<O, ?>)methodSource) && !this.isMutator((Method<O, ?>)methodSource)) continue;
            propertyNames.add(this.extractPropertyName((Method<O, ?>)methodSource));
        }
        for (FieldSource fieldSource : this.getFields()) {
            if (fieldSource.isStatic()) continue;
            propertyNames.add(fieldSource.getName());
        }
        ArrayList<PropertySource<O>> result = new ArrayList<PropertySource<O>>(propertyNames.size());
        for (String name : propertyNames) {
            result.add(new PropertyImpl(name, this.getOrigin()));
        }
        return result;
    }

    public List<PropertySource<O>> getProperties(Class<?> type) {
        LinkedHashSet<String> propertyNames = new LinkedHashSet<String>();
        for (MethodSource<O> methodSource : this.getMethods()) {
            if (!this.isAccessor((Method<O, ?>)methodSource) && !this.isMutator((Method<O, ?>)methodSource) || !methodSource.getReturnType().getQualifiedName().equals(type.getCanonicalName())) continue;
            propertyNames.add(this.extractPropertyName((Method<O, ?>)methodSource));
        }
        for (FieldSource fieldSource : this.getFields()) {
            if (fieldSource.isStatic() || !fieldSource.getType().getQualifiedName().equals(type.getCanonicalName())) continue;
            propertyNames.add(fieldSource.getName());
        }
        ArrayList<PropertySource<O>> result = new ArrayList<PropertySource<O>>(propertyNames.size());
        for (String name : propertyNames) {
            result.add(new PropertyImpl(name, this.getOrigin()));
        }
        return result;
    }

    private boolean isAccessor(Method<O, ?> method) {
        return this.extractPropertyName(method) != null && method.getParameters().isEmpty() && !method.isReturnTypeVoid();
    }

    private boolean isMutator(Method<O, ?> method) {
        return this.extractPropertyName(method) != null && method.getParameters().size() == 1 && method.isReturnTypeVoid();
    }

    private String extractPropertyName(Method<O, ?> method) {
        if (GET_SET_PATTERN.matcher(method.getName()).matches()) {
            return StringUtils.uncapitalize(method.getName().substring(3));
        }
        return null;
    }
}

