/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.IContainer;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.IFile;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.IFolder;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.IResource;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.CoreException;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IPath;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IStatus;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.OperationCanceledException;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.Path;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.CompletionRequestor;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IBuffer;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IBufferFactory;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IClassFile;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.ICodeCompletionRequestor;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.ICompilationUnit;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.ICompletionRequestor;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IJavaElement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IJavaProject;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IOrdinaryClassFile;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IPackageFragment;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IParent;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IProblemRequestor;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.ISourceRange;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IType;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.ITypeRoot;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.JavaConventions;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.JavaModelException;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.SourceRange;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.WorkingCopyOwner;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.IProblem;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.codeassist.CompletionRequestorWrapper;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.BecomeWorkingCopyOperation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.BufferFactoryWrapper;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.ClassFileInfo;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.ClassFileWorkingCopy;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JarPackageFragment;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaElement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaModelManager;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaModelStatus;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.Openable;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.PackageFragment;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.SourceMapper;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.util.Util;

public abstract class AbstractClassFile
extends Openable
implements IClassFile,
SuffixConstants {
    protected String name;

    protected AbstractClassFile(PackageFragment parent, String nameWithoutExtension) {
        super(parent);
        this.name = nameWithoutExtension;
    }

    @Override
    public ICompilationUnit becomeWorkingCopy(IProblemRequestor problemRequestor, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        ClassFileWorkingCopy workingCopy;
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(workingCopy = new ClassFileWorkingCopy(this, owner == null ? DefaultWorkingCopyOwner.PRIMARY : owner), false, true, null);
        if (perWorkingCopyInfo == null) {
            this.close();
            BecomeWorkingCopyOperation operation = new BecomeWorkingCopyOperation(workingCopy, problemRequestor);
            operation.runOperation(monitor);
            return workingCopy;
        }
        return perWorkingCopyInfo.workingCopy;
    }

    @Override
    @Deprecated
    public void codeComplete(int offset, ICompletionRequestor requestor) throws JavaModelException {
        this.codeComplete(offset, requestor, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    @Deprecated
    public void codeComplete(int offset, ICompletionRequestor requestor, WorkingCopyOwner owner) throws JavaModelException {
        if (requestor == null) {
            throw new IllegalArgumentException("Completion requestor cannot be null");
        }
        this.codeComplete(offset, (CompletionRequestor)new CompletionRequestorWrapper(requestor), owner);
    }

    @Override
    public void codeComplete(int offset, CompletionRequestor requestor) throws JavaModelException {
        this.codeComplete(offset, requestor, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public void codeComplete(int offset, CompletionRequestor requestor, IProgressMonitor monitor) throws JavaModelException {
        this.codeComplete(offset, requestor, DefaultWorkingCopyOwner.PRIMARY, monitor);
    }

    @Override
    public void codeComplete(int offset, CompletionRequestor requestor, WorkingCopyOwner owner) throws JavaModelException {
        this.codeComplete(offset, requestor, owner, null);
    }

    @Override
    public abstract void codeComplete(int var1, CompletionRequestor var2, WorkingCopyOwner var3, IProgressMonitor var4) throws JavaModelException;

    @Override
    public IJavaElement[] codeSelect(int offset, int length) throws JavaModelException {
        return this.codeSelect(offset, length, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public abstract IJavaElement[] codeSelect(int var1, int var2, WorkingCopyOwner var3) throws JavaModelException;

    @Override
    protected Object createElementInfo() {
        return new ClassFileInfo();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AbstractClassFile)) {
            return false;
        }
        AbstractClassFile other = (AbstractClassFile)o;
        return this.name.equals(other.name) && this.parent.equals(other.parent);
    }

    protected IJavaElement findElement(IJavaElement elt, int position, SourceMapper mapper) {
        SourceRange range = mapper.getSourceRange(elt);
        if (range == null || position < range.getOffset() || range.getOffset() + range.getLength() - 1 < position) {
            return null;
        }
        if (elt instanceof IParent) {
            try {
                IJavaElement[] children = ((IParent)((Object)elt)).getChildren();
                int i = 0;
                while (i < children.length) {
                    IJavaElement match = this.findElement(children[i], position, mapper);
                    if (match != null) {
                        return match;
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return elt;
    }

    public String getPathIdentifier() {
        JavaElement pkg = (JavaElement)this.getParent();
        if (pkg instanceof JarPackageFragment) {
            JarPackageFragmentRoot root = (JarPackageFragmentRoot)pkg.getParent();
            String entryName = Util.concatWith(((PackageFragment)pkg).names, this.getElementName(), '/');
            entryName = root.getClassFilePath(entryName);
            String rootPath = root.getPath().toOSString();
            if (org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.util.Util.isJrt(rootPath)) {
                return String.valueOf(rootPath) + '/' + root.getElementName() + '/' + entryName;
            }
            return String.valueOf(rootPath) + '/' + entryName;
        }
        IFile file = (IFile)this.resource();
        IPath location = file.getLocation();
        return location == null ? file.getFullPath().toPortableString() : location.toOSString();
    }

    @Override
    public byte[] getBytes() throws JavaModelException {
        JavaElement pkg = (JavaElement)this.getParent();
        if (pkg instanceof JarPackageFragment) {
            JarPackageFragmentRoot root = (JarPackageFragmentRoot)pkg.getParent();
            try {
                String entryName = Util.concatWith(((PackageFragment)pkg).names, this.getElementName(), '/');
                entryName = root.getClassFilePath(entryName);
                return this.getClassFileContent(root, entryName);
            }
            catch (IOException ioe) {
                throw new JavaModelException(ioe, 985);
            }
            catch (CoreException e) {
                if (e instanceof JavaModelException) {
                    throw (JavaModelException)e;
                }
                throw new JavaModelException(e);
            }
        }
        IFile file = (IFile)this.resource();
        return Util.getResourceContentsAsByteArray(file);
    }

    protected byte[] getClassFileContent(JarPackageFragmentRoot root, String className) throws CoreException, IOException {
        byte[] contents = null;
        String rootPath = root.getPath().toOSString();
        if (org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.util.Util.isJrt(rootPath)) {
            contents = JRTUtil.getClassfileContent(new File(rootPath), className, root.getElementName());
        } else {
            ZipFile zip = root.getJar();
            try {
                ZipEntry ze = zip.getEntry(className);
                if (ze != null) {
                    contents = org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.util.Util.getZipEntryByteContent(ze, zip);
                }
            }
            finally {
                JavaModelManager.getJavaModelManager().closeZipFile(zip);
            }
        }
        if (contents == null && Thread.interrupted()) {
            throw new OperationCanceledException();
        }
        return contents;
    }

    @Override
    public IBuffer getBuffer() throws JavaModelException {
        IStatus status = this.validateClassFile();
        if (status.isOK()) {
            return super.getBuffer();
        }
        switch (status.getCode()) {
            case 967: 
            case 1006: {
                return null;
            }
        }
        throw new JavaModelException(status);
    }

    public ITypeRoot getTypeRoot() {
        return this;
    }

    @Override
    public IResource getCorrespondingResource() throws JavaModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getParent().getParent();
        if (root.isArchive()) {
            return null;
        }
        return this.getUnderlyingResource();
    }

    public IJavaElement getElementAtConsideringSibling(int position) throws JavaModelException {
        IPackageFragment fragment = (IPackageFragment)this.getParent();
        PackageFragmentRoot root = (PackageFragmentRoot)fragment.getAncestor(3);
        SourceMapper mapper = root.getSourceMapper();
        if (mapper == null) {
            return null;
        }
        int index = this.name.indexOf(36);
        int prefixLength = index < 0 ? this.name.length() : index;
        IType type = null;
        int start = -1;
        int end = Integer.MAX_VALUE;
        IJavaElement[] children = fragment.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IOrdinaryClassFile) {
                int childPrefixLength;
                IOrdinaryClassFile classFile = (IOrdinaryClassFile)children[i];
                String childName = classFile.getElementName();
                int childIndex = childName.indexOf(36);
                int n = childPrefixLength = childIndex < 0 ? childName.indexOf(46) : childIndex;
                if (prefixLength == childPrefixLength && this.name.regionMatches(0, childName, 0, prefixLength)) {
                    classFile.getBuffer();
                    SourceRange range = mapper.getSourceRange(classFile.getType());
                    if (range != SourceMapper.UNKNOWN_RANGE) {
                        int newStart = range.getOffset();
                        int newEnd = newStart + range.getLength() - 1;
                        if (newStart > start && newEnd < end && newStart <= position && newEnd >= position) {
                            type = classFile.getType();
                            start = newStart;
                            end = newEnd;
                        }
                    }
                }
            }
            ++i;
        }
        if (type != null) {
            return this.findElement(type, position, mapper);
        }
        return null;
    }

    @Override
    public String getElementName() {
        return String.valueOf(this.name) + ".class";
    }

    @Override
    public int getElementType() {
        return 6;
    }

    @Override
    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getPath();
        }
        return this.getParent().getPath().append(this.getElementName());
    }

    @Override
    public IResource resource(PackageFragmentRoot root) {
        return ((IContainer)((Openable)this.parent).resource(root)).getFile(new Path(this.getElementName()));
    }

    @Override
    public String getSource() throws JavaModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return null;
        }
        return buffer.getContents();
    }

    @Override
    public ISourceRange getSourceRange() throws JavaModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer != null) {
            String contents = buffer.getContents();
            if (contents == null) {
                return null;
            }
            return new SourceRange(0, contents.length());
        }
        return null;
    }

    @Override
    @Deprecated
    public IJavaElement getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory) throws JavaModelException {
        return this.getWorkingCopy(BufferFactoryWrapper.create(factory), monitor);
    }

    @Override
    protected boolean hasBuffer() {
        return true;
    }

    @Override
    public int hashCode() {
        return Util.combineHashCodes(this.name.hashCode(), this.parent.hashCode());
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    private IStatus validateClassFile() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        try {
            if (root.getKind() != 2) {
                return new JavaModelStatus(967, root);
            }
        }
        catch (JavaModelException e) {
            return e.getJavaModelStatus();
        }
        IJavaProject project = this.getJavaProject();
        return JavaConventions.validateClassFileName(this.getElementName(), project.getOption("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.source", true), project.getOption("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.compliance", true));
    }

    @Override
    @Deprecated
    public void codeComplete(int offset, final ICodeCompletionRequestor requestor) throws JavaModelException {
        if (requestor == null) {
            this.codeComplete(offset, (ICompletionRequestor)null);
            return;
        }
        this.codeComplete(offset, new ICompletionRequestor(){

            @Override
            public void acceptAnonymousType(char[] superTypePackageName, char[] superTypeName, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            @Override
            public void acceptClass(char[] packageName, char[] className, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptClass(packageName, className, completionName, modifiers, completionStart, completionEnd);
            }

            @Override
            public void acceptError(IProblem error) {
            }

            @Override
            public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] fieldName, char[] typePackageName, char[] typeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptField(declaringTypePackageName, declaringTypeName, fieldName, typePackageName, typeName, completionName, modifiers, completionStart, completionEnd);
            }

            @Override
            public void acceptInterface(char[] packageName, char[] interfaceName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptInterface(packageName, interfaceName, completionName, modifiers, completionStart, completionEnd);
            }

            @Override
            public void acceptKeyword(char[] keywordName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptKeyword(keywordName, completionStart, completionEnd);
            }

            @Override
            public void acceptLabel(char[] labelName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptLabel(labelName, completionStart, completionEnd);
            }

            @Override
            public void acceptLocalVariable(char[] localVarName, char[] typePackageName, char[] typeName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            @Override
            public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptMethod(declaringTypePackageName, declaringTypeName, selector, parameterPackageNames, parameterTypeNames, returnTypePackageName, returnTypeName, completionName, modifiers, completionStart, completionEnd);
            }

            @Override
            public void acceptMethodDeclaration(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            @Override
            public void acceptModifier(char[] modifierName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptModifier(modifierName, completionStart, completionEnd);
            }

            @Override
            public void acceptPackage(char[] packageName, char[] completionName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptPackage(packageName, completionName, completionStart, completionEnd);
            }

            @Override
            public void acceptType(char[] packageName, char[] typeName, char[] completionName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptType(packageName, typeName, completionName, completionStart, completionEnd);
            }

            @Override
            public void acceptVariableName(char[] typePackageName, char[] typeName, char[] varName, char[] completionName, int completionStart, int completionEnd, int relevance) {
            }
        });
    }

    @Override
    protected IStatus validateExistence(IResource underlyingResource) {
        IStatus status = this.validateClassFile();
        if (!status.isOK()) {
            return status;
        }
        if (underlyingResource != null) {
            PackageFragmentRoot root;
            if (!underlyingResource.isAccessible()) {
                return this.newDoesNotExistStatus();
            }
            if (underlyingResource instanceof IFolder && (root = this.getPackageFragmentRoot()).isArchive()) {
                return root.newDoesNotExistStatus();
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    @Override
    public ISourceRange getNameRange() {
        return null;
    }
}

