/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.search;

import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.CoreException;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IPath;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.OperationCanceledException;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.Path;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.search.IJavaSearchScope;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.search.IParallelizable;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.search.SearchDocument;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.search.SearchParticipant;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.search.SearchPattern;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.search.SearchRequestor;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.index.IndexLocation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.search.IndexSelector;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.search.indexing.BinaryIndexer;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.search.indexing.ManifestIndexer;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.search.indexing.SourceIndexer;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.util.Util;

public class JavaSearchParticipant
extends SearchParticipant
implements IParallelizable {
    private final ThreadLocal indexSelector = new ThreadLocal();
    private final ThreadLocal<SourceIndexer> sourceIndexer = new ThreadLocal();

    @Override
    public void beginSearching() {
        super.beginSearching();
        this.indexSelector.set(null);
    }

    @Override
    public void doneSearching() {
        this.indexSelector.set(null);
        super.doneSearching();
    }

    @Override
    public String getDescription() {
        return "Java";
    }

    @Override
    public SearchDocument getDocument(String documentPath) {
        return new JavaSearchDocument(documentPath, this);
    }

    @Override
    public void indexDocument(SearchDocument document, IPath indexPath) {
        document.removeAllIndexEntries();
        String documentPath = document.getPath();
        if (Util.isJavaLikeFileName(documentPath)) {
            SourceIndexer indexer = new SourceIndexer(document);
            this.sourceIndexer.set(indexer);
            indexer.indexDocument();
        } else if (org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(documentPath)) {
            new BinaryIndexer(document).indexDocument();
        } else if (documentPath.endsWith("Automatic-Module-Name")) {
            new ManifestIndexer(document).indexDocument();
        }
    }

    @Override
    public void indexResolvedDocument(SearchDocument document, IPath indexPath) {
        String documentPath = document.getPath();
        if (Util.isJavaLikeFileName(documentPath)) {
            SourceIndexer indexer = this.sourceIndexer.get();
            if (indexer != null) {
                indexer.indexResolvedDocument();
            }
            this.sourceIndexer.remove();
        }
    }

    @Override
    public void resolveDocument(SearchDocument document) {
        SourceIndexer indexer;
        String documentPath = document.getPath();
        if (Util.isJavaLikeFileName(documentPath) && (indexer = this.sourceIndexer.get()) != null) {
            indexer.resolveDocument();
        }
    }

    @Override
    public void locateMatches(SearchDocument[] indexMatches, SearchPattern pattern, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        MatchLocator matchLocator = new MatchLocator(pattern, requestor, scope, monitor);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        matchLocator.locateMatches(indexMatches);
    }

    @Override
    public IPath[] selectIndexes(SearchPattern pattern, IJavaSearchScope scope) {
        IndexSelector selector = this.getIndexSelector(pattern, scope);
        IndexLocation[] urls = selector.getIndexLocations();
        IPath[] paths = new IPath[urls.length];
        int i = 0;
        while (i < urls.length) {
            paths[i] = new Path(urls[i].getIndexFile().getPath());
            ++i;
        }
        return paths;
    }

    private IndexSelector getIndexSelector(SearchPattern pattern, IJavaSearchScope scope) {
        IndexSelector selector = (IndexSelector)this.indexSelector.get();
        if (selector == null) {
            selector = new IndexSelector(scope, pattern);
            this.indexSelector.set(selector);
        }
        return selector;
    }

    public IndexLocation[] selectIndexURLs(SearchPattern pattern, IJavaSearchScope scope) {
        IndexSelector selector = this.getIndexSelector(pattern, scope);
        return selector.getIndexLocations();
    }

    @Override
    public boolean isParallelSearchSupported() {
        return true;
    }
}

