/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.connect;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.container.Module;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.connect.ConnectBundleFile;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.connect.ConnectInputStream;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.connect.DelegatingConnectClassLoader;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.hookregistry.ActivatorHookFactory;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.hookregistry.HookConfigurator;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.hookregistry.StorageHookFactory;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.BundleLoader;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.BundleInfo;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.storage.bundlefile.BundleFileWrapperChain;
import org.jboss.forge.roaster._shade.org.osgi.framework.BundleActivator;
import org.jboss.forge.roaster._shade.org.osgi.framework.BundleContext;
import org.jboss.forge.roaster._shade.org.osgi.framework.BundleException;
import org.jboss.forge.roaster._shade.org.osgi.framework.connect.ConnectModule;
import org.jboss.forge.roaster._shade.org.osgi.framework.connect.ModuleConnector;

public class ConnectHookConfigurator
implements HookConfigurator {
    static final Collection<String> CONNECT_TAG_NAMESPACES = new ArrayList<String>(Arrays.asList("osgi.wiring.bundle", "osgi.wiring.host", "osgi.identity"));

    @Override
    public void addHooks(HookRegistry hookRegistry) {
        final EquinoxContainer.ConnectModules connectModules = hookRegistry.getContainer().getConnectModules();
        final ModuleConnector moduleConnector = connectModules.getModuleConnector();
        hookRegistry.addStorageHookFactory(new StorageHookFactory<Object, Object, StorageHookFactory.StorageHook<Object, Object>>(){

            @Override
            protected StorageHookFactory.StorageHook<Object, Object> createStorageHook(final BundleInfo.Generation generation) {
                final ConnectModule m = connectModules.getConnectModule(generation.getBundleInfo().getLocation());
                return new StorageHookFactory.StorageHook<Object, Object>(generation, this.getClass()){
                    boolean hasModule;
                    {
                        super($anonymous0, $anonymous1);
                        this.hasModule = false;
                    }

                    @Override
                    public void save(Object saveContext, DataOutputStream os) throws IOException {
                        os.writeBoolean(m != null);
                    }

                    @Override
                    public void load(Object loadContext, DataInputStream is) throws IOException {
                        this.hasModule = is.readBoolean();
                    }

                    @Override
                    public void validate() throws IllegalStateException {
                        if (this.hasModule && m == null) {
                            throw new IllegalStateException("Connect Factory no longer has the module at locataion: " + generation.getBundleInfo().getLocation());
                        }
                    }

                    @Override
                    public ModuleRevisionBuilder adaptModuleRevisionBuilder(ModuleContainerAdaptor.ModuleEvent operation, Module origin, ModuleRevisionBuilder builder) {
                        if (m != null) {
                            builder.getCapabilities().stream().filter(c -> CONNECT_TAG_NAMESPACES.contains(c.getNamespace())).forEach(c -> c.getAttributes().compute("tags", (k, v) -> {
                                if (v == null) {
                                    return Collections.singletonList("osgi.connect");
                                }
                                if (v instanceof List) {
                                    ArrayList<String> l = new ArrayList<String>((List)v);
                                    l.add("osgi.connect");
                                    return Collections.unmodifiableList(l);
                                }
                                return Arrays.asList(v, "osgi.connect");
                            }));
                            return builder;
                        }
                        return null;
                    }
                };
            }

            @Override
            public URLConnection handleContentConnection(Module module, String location, InputStream in) {
                block5: {
                    if (in != null) {
                        return null;
                    }
                    if (location == null) {
                        location = module.getLocation();
                    }
                    try {
                        ConnectModule m = connectModules.connect(location);
                        if (m != null) {
                            return ConnectInputStream.URL_CONNECTION_INSTANCE;
                        }
                    }
                    catch (IllegalStateException e) {
                        if (!(e.getCause() instanceof BundleException)) break block5;
                        EquinoxContainer.sneakyThrow(e.getCause());
                    }
                }
                return null;
            }
        });
        if (moduleConnector == null) {
            return;
        }
        hookRegistry.addClassLoaderHook(new ClassLoaderHook(){

            @Override
            public ModuleClassLoader createClassLoader(ClassLoader parent, EquinoxConfiguration configuration, BundleLoader delegate, BundleInfo.Generation generation) {
                ConnectModule m = connectModules.getConnectModule(generation.getBundleInfo().getLocation());
                if (m != null) {
                    BundleFile bundlefile = generation.getBundleFile();
                    if (bundlefile instanceof BundleFileWrapperChain) {
                        BundleFileWrapperChain chain = (BundleFileWrapperChain)bundlefile;
                        while (chain.getNext() != null) {
                            chain = chain.getNext();
                        }
                        bundlefile = chain.getBundleFile();
                    }
                    if (bundlefile instanceof ConnectBundleFile) {
                        return ((ConnectBundleFile)bundlefile).getClassLoader().map(l -> new DelegatingConnectClassLoader(parent, configuration, delegate, generation, (ClassLoader)l)).orElse(null);
                    }
                }
                return null;
            }
        });
        hookRegistry.addActivatorHookFactory(new ActivatorHookFactory(){

            @Override
            public BundleActivator createActivator() {
                final ArrayList activators = new ArrayList();
                moduleConnector.newBundleActivator().ifPresent(a -> {
                    boolean bl = activators.add(a);
                });
                return new BundleActivator(){

                    @Override
                    public void start(BundleContext context) throws Exception {
                        for (BundleActivator activator : activators) {
                            activator.start(context);
                        }
                    }

                    @Override
                    public void stop(BundleContext context) throws Exception {
                        for (BundleActivator activator : activators) {
                            activator.stop(context);
                        }
                    }
                };
            }
        });
    }
}

