/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.log;

import java.util.HashMap;
import java.util.Map;
import org.jboss.forge.roaster._shade.org.eclipse.equinox.log.ExtendedLogService;
import org.jboss.forge.roaster._shade.org.eclipse.equinox.log.Logger;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.log.ExtendedLogServiceFactory;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.log.FormatterLoggerImpl;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.log.LoggerImpl;
import org.jboss.forge.roaster._shade.org.osgi.framework.Bundle;
import org.jboss.forge.roaster._shade.org.osgi.framework.ServiceReference;
import org.jboss.forge.roaster._shade.org.osgi.service.log.FormatterLogger;
import org.jboss.forge.roaster._shade.org.osgi.service.log.LoggerConsumer;

public class ExtendedLogServiceImpl
implements ExtendedLogService {
    private final ExtendedLogServiceFactory factory;
    private volatile Bundle bundle;
    private final Map<Class<? extends org.jboss.forge.roaster._shade.org.osgi.service.log.Logger>, Map<String, LoggerImpl>> loggerCache = new HashMap<Class<? extends org.jboss.forge.roaster._shade.org.osgi.service.log.Logger>, Map<String, LoggerImpl>>();
    private final String LOG_SERVICE = "LogService";

    public ExtendedLogServiceImpl(ExtendedLogServiceFactory factory, Bundle bundle) {
        this.factory = factory;
        this.bundle = bundle;
        this.loggerCache.put(org.jboss.forge.roaster._shade.org.osgi.service.log.Logger.class, new HashMap());
        this.loggerCache.put(FormatterLogger.class, new HashMap());
    }

    @Override
    public void log(int level, String message) {
        this.log(null, level, message, null);
    }

    @Override
    public void log(int level, String message, Throwable exception) {
        this.log(null, level, message, exception);
    }

    @Override
    public void log(ServiceReference<?> sr, int level, String message) {
        this.log(sr, level, message, null);
    }

    @Override
    public void log(ServiceReference<?> sr, int level, String message, Throwable exception) {
        this.getLogger((String)null).log(sr, level, message, exception);
    }

    @Override
    public void log(Object context, int level, String message) {
        this.log(context, level, message, null);
    }

    @Override
    public void log(Object context, int level, String message, Throwable exception) {
        this.getLogger((String)null).log(context, level, message, exception);
    }

    @Override
    public Logger getLogger(String name) {
        return (Logger)this.getLogger(name, org.jboss.forge.roaster._shade.org.osgi.service.log.Logger.class);
    }

    @Override
    public Logger getLogger(Bundle logBundle, String name) {
        if (logBundle == null || logBundle == this.bundle) {
            return this.getLogger(name);
        }
        this.factory.checkLogPermission();
        ExtendedLogServiceImpl bundleLogService = this.factory.getLogService(logBundle);
        return bundleLogService.getLogger(name);
    }

    @Override
    public <L extends org.jboss.forge.roaster._shade.org.osgi.service.log.Logger> L getLogger(Bundle logBundle, String name, Class<L> loggerType) {
        if (logBundle == null || (logBundle.getState() & 3) != 0) {
            throw new IllegalArgumentException("The bundle is not resolved: " + logBundle);
        }
        ExtendedLogServiceImpl bundleLogService = this.factory.getLogService(logBundle);
        return bundleLogService.getLogger(name, loggerType);
    }

    @Override
    public String getName() {
        return this.getLogger((String)null).getName();
    }

    @Override
    public boolean isLoggable(int level) {
        return this.getLogger((String)null).isLoggable(level);
    }

    boolean isLoggable(String name, int level) {
        return this.factory.isLoggable(this.bundle, name, level);
    }

    void setBundle(Bundle bundle) {
        this.factory.contextsLock.writeLock().lock();
        try {
            Bundle previous = this.bundle;
            this.bundle = bundle;
            this.factory.loggerContextTargetMap.replaceSystemBundleLogService(previous, bundle);
        }
        finally {
            this.factory.contextsLock.writeLock().unlock();
        }
    }

    Bundle getBundle() {
        return this.bundle;
    }

    ExtendedLogServiceFactory getFactory() {
        return this.factory;
    }

    @Override
    public org.jboss.forge.roaster._shade.org.osgi.service.log.Logger getLogger(Class<?> clazz) {
        return this.getLogger(clazz.getName());
    }

    @Override
    public <L extends org.jboss.forge.roaster._shade.org.osgi.service.log.Logger> L getLogger(String name, Class<L> loggerType) {
        if (name == null) {
            Bundle current = this.bundle;
            String bsn = current == null ? null : current.getSymbolicName();
            name = bsn == null ? "LogService" : "LogService." + bsn;
        }
        LoggerImpl logger = null;
        Map<String, LoggerImpl> loggers = null;
        this.factory.contextsLock.readLock().lock();
        try {
            loggers = this.loggerCache.get(loggerType);
            if (loggers == null) {
                throw new IllegalArgumentException(loggerType.getName());
            }
            logger = loggers.get(name);
        }
        finally {
            this.factory.contextsLock.readLock().unlock();
        }
        if (logger == null) {
            ExtendedLogServiceFactory.EquinoxLoggerContext loggerContext = this.factory.loggerContextTargetMap.getEffectiveLoggerContext(this.bundle);
            if (loggerType == FormatterLogger.class) {
                logger = new FormatterLoggerImpl(this, name, loggerContext);
            } else if (loggerType == org.jboss.forge.roaster._shade.org.osgi.service.log.Logger.class) {
                logger = new LoggerImpl(this, name, loggerContext);
            } else {
                throw new IllegalArgumentException(loggerType.getName());
            }
            this.factory.contextsLock.writeLock().lock();
            try {
                LoggerImpl existing = loggers.get(name);
                if (existing == null) {
                    loggers.put(name, logger);
                } else {
                    logger = existing;
                }
            }
            finally {
                this.factory.contextsLock.writeLock().unlock();
            }
        }
        return (L)((org.jboss.forge.roaster._shade.org.osgi.service.log.Logger)loggerType.cast(logger));
    }

    @Override
    public <L extends org.jboss.forge.roaster._shade.org.osgi.service.log.Logger> L getLogger(Class<?> clazz, Class<L> loggerType) {
        return this.getLogger(clazz.getName(), loggerType);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLogger((String)null).isTraceEnabled();
    }

    @Override
    public void trace(String message) {
        this.getLogger((String)null).trace(message);
    }

    @Override
    public void trace(String format, Object arg) {
        this.getLogger((String)null).trace(format, arg);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.getLogger((String)null).trace(format, arg1, arg2);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.getLogger((String)null).trace(format, arguments);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLogger((String)null).isDebugEnabled();
    }

    @Override
    public void debug(String message) {
        this.getLogger((String)null).debug(message);
    }

    @Override
    public void debug(String format, Object arg) {
        this.getLogger((String)null).debug(format, arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.getLogger((String)null).debug(format, arg1, arg2);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.getLogger((String)null).debug(format, arguments);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.getLogger((String)null).isInfoEnabled();
    }

    @Override
    public void info(String message) {
        this.getLogger((String)null).info(message);
    }

    @Override
    public void info(String format, Object arg) {
        this.getLogger((String)null).info(format, arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.getLogger((String)null).info(format, arg1, arg2);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.getLogger((String)null).info(format, arguments);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.getLogger((String)null).isWarnEnabled();
    }

    @Override
    public void warn(String message) {
        this.getLogger((String)null).warn(message);
    }

    @Override
    public void warn(String format, Object arg) {
        this.getLogger((String)null).warn(format, arg);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.getLogger((String)null).warn(format, arg1, arg2);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.getLogger((String)null).warn(format, arguments);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.getLogger((String)null).isErrorEnabled();
    }

    @Override
    public void error(String message) {
        this.getLogger((String)null).error(message);
    }

    @Override
    public void error(String format, Object arg) {
        this.getLogger((String)null).error(format, arg);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.getLogger((String)null).error(format, arg1, arg2);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.getLogger((String)null).error(format, arguments);
    }

    @Override
    public void audit(String message) {
        this.getLogger((String)null).audit(message);
    }

    @Override
    public void audit(String format, Object arg) {
        this.getLogger((String)null).audit(format, arg);
    }

    @Override
    public void audit(String format, Object arg1, Object arg2) {
        this.getLogger((String)null).audit(format, arg1, arg2);
    }

    @Override
    public void audit(String format, Object ... arguments) {
        this.getLogger((String)null).audit(format, arguments);
    }

    @Override
    public <E extends Exception> void trace(LoggerConsumer<E> consumer) throws E {
        this.getLogger((String)null).trace(consumer);
    }

    @Override
    public <E extends Exception> void debug(LoggerConsumer<E> consumer) throws E {
        this.getLogger((String)null).debug(consumer);
    }

    @Override
    public <E extends Exception> void info(LoggerConsumer<E> consumer) throws E {
        this.getLogger((String)null).info(consumer);
    }

    @Override
    public <E extends Exception> void warn(LoggerConsumer<E> consumer) throws E {
        this.getLogger((String)null).warn(consumer);
    }

    @Override
    public <E extends Exception> void error(LoggerConsumer<E> consumer) throws E {
        this.getLogger((String)null).error(consumer);
    }

    void applyLogLevels(ExtendedLogServiceFactory.EquinoxLoggerContext effectiveLoggerContext) {
        for (Map<String, LoggerImpl> loggers : this.loggerCache.values()) {
            for (LoggerImpl logger : loggers.values()) {
                logger.applyLoggerContext(effectiveLoggerContext);
            }
        }
    }
}

