/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jboss.forge.roaster.ParserException;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.BodyDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Javadoc;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Modifier;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TypeDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TypeParameter;
import org.jboss.forge.roaster._shade.org.eclipse.jface.text.Document;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.ast.ModifierAccessor;
import org.jboss.forge.roaster.model.ast.TypeDeclarationFinderVisitor;
import org.jboss.forge.roaster.model.impl.JavaSourceImpl;
import org.jboss.forge.roaster.model.impl.TypeImpl;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.StaticCapableSource;
import org.jboss.forge.roaster.model.source.TypeHolderSource;
import org.jboss.forge.roaster.spi.JavaParserImpl;

public abstract class AbstractJavaSource<O extends JavaSource<O>>
extends JavaSourceImpl<O>
implements TypeHolderSource<O>,
StaticCapableSource<O> {
    protected final BodyDeclaration body;
    private final ModifierAccessor modifiers = new ModifierAccessor();

    protected AbstractJavaSource(JavaSource<?> enclosingType, Document document, CompilationUnit unit, BodyDeclaration body) {
        super(enclosingType, document, unit);
        this.body = body;
    }

    public List<JavaSource<?>> getNestedTypes() {
        List<AbstractTypeDeclaration> declarations = this.getNestedDeclarations(this.body);
        ArrayList result = new ArrayList();
        for (AbstractTypeDeclaration declaration : declarations) {
            result.add(JavaParserImpl.getJavaSource(this, this.document, this.unit, declaration));
        }
        return result;
    }

    public boolean hasNestedType(JavaType<?> type) {
        for (JavaSource<?> nested : this.getNestedTypes()) {
            if (!Objects.equals(nested.getQualifiedName(), type.getQualifiedName()) && !Objects.equals(nested.getName(), type.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasNestedType(String name) {
        for (JavaSource<?> nested : this.getNestedTypes()) {
            if (!Objects.equals(nested.getName(), name) && !Objects.equals(nested.getQualifiedName(), name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNestedType(Class<?> type) {
        for (JavaSource<?> nested : this.getNestedTypes()) {
            if (!Objects.equals(nested.getName(), type.getSimpleName()) && !Objects.equals(nested.getQualifiedName(), type.getName())) continue;
            return true;
        }
        return false;
    }

    public JavaSource<?> getNestedType(String name) {
        for (JavaSource<?> nested : this.getNestedTypes()) {
            if (!Objects.equals(nested.getName(), name) && !Objects.equals(nested.getQualifiedName(), name)) continue;
            return nested;
        }
        return null;
    }

    public <NESTED_TYPE extends JavaSource<?>> NESTED_TYPE addNestedType(NESTED_TYPE type) {
        if (!(type instanceof AbstractJavaSource)) {
            throw new IllegalArgumentException("type must be an AbstractJavaSource instance");
        }
        List bodyDeclarations = this.getDeclaration().bodyDeclarations();
        BodyDeclaration nestedBody = ((AbstractJavaSource)type).body;
        bodyDeclarations.add(ASTNode.copySubtree(this.unit.getAST(), nestedBody));
        return (NESTED_TYPE)this.getNestedType(type.getName());
    }

    public O removeNestedType(JavaSource<?> type) {
        if (type instanceof AbstractJavaSource) {
            BodyDeclaration bodyDeclaration = ((AbstractJavaSource)type).body;
            List bodyDeclarations = this.getDeclaration().bodyDeclarations();
            bodyDeclarations.remove(bodyDeclaration);
        }
        return (O)this;
    }

    public <NESTED_TYPE extends JavaSource<?>> NESTED_TYPE addNestedType(Class<NESTED_TYPE> type) {
        JavaSource nestedType = Roaster.create(type);
        return (NESTED_TYPE)this.addNestedType(nestedType);
    }

    public <NESTED_TYPE extends JavaSource<?>> NESTED_TYPE addNestedType(String declaration) {
        JavaSource nestedType = (JavaSource)Roaster.parse(JavaSource.class, (String)declaration);
        return (NESTED_TYPE)this.addNestedType(nestedType);
    }

    public boolean isStatic() {
        return this.modifiers.hasModifier(this.getDeclaration(), Modifier.ModifierKeyword.STATIC_KEYWORD);
    }

    public O setStatic(boolean _static) {
        if (_static) {
            this.modifiers.addModifier(this.getDeclaration(), Modifier.ModifierKeyword.STATIC_KEYWORD);
        } else {
            this.modifiers.removeModifier(this.getDeclaration(), Modifier.ModifierKeyword.STATIC_KEYWORD);
        }
        return (O)this;
    }

    private List<AbstractTypeDeclaration> getNestedDeclarations(BodyDeclaration body) {
        TypeDeclarationFinderVisitor typeDeclarationFinder = new TypeDeclarationFinderVisitor();
        body.accept(typeDeclarationFinder);
        List<AbstractTypeDeclaration> declarations = typeDeclarationFinder.getTypeDeclarations();
        ArrayList<AbstractTypeDeclaration> result = new ArrayList<AbstractTypeDeclaration>(declarations);
        if (!declarations.isEmpty()) {
            result.remove(declarations.remove(0));
            for (AbstractTypeDeclaration declaration : declarations) {
                result.removeAll(this.getNestedDeclarations(declaration));
            }
        }
        return result;
    }

    @Override
    protected AbstractTypeDeclaration getDeclaration() {
        if (this.body instanceof AbstractTypeDeclaration) {
            return (AbstractTypeDeclaration)this.body;
        }
        throw new ParserException("Source body was not of the expected type.");
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hash(this.body);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractJavaSource other = (AbstractJavaSource)obj;
        if (this.body == null ? other.body != null : !this.body.equals(other.body)) {
            return false;
        }
        return super.equals(obj);
    }

    public O setName(String name) {
        AbstractTypeDeclaration typeDeclaration = this.getDeclaration();
        TypeImpl<AbstractJavaSource> type = new TypeImpl<AbstractJavaSource>(this, null, name);
        typeDeclaration.setName(this.unit.getAST().newSimpleName(type.getName()));
        if (typeDeclaration instanceof TypeDeclaration) {
            TypeDeclaration td = (TypeDeclaration)typeDeclaration;
            for (Type<AbstractJavaSource> arg : type.getTypeArguments()) {
                TypeParameter typeParameter = this.unit.getAST().newTypeParameter();
                typeParameter.setName(this.unit.getAST().newSimpleName(arg.getName()));
                td.typeParameters().add(typeParameter);
            }
        }
        return this.updateTypeNames(name);
    }

    public String getName() {
        return this.getDeclaration().getName().getIdentifier();
    }

    @Override
    protected Javadoc getJDTJavaDoc() {
        return this.body.getJavadoc();
    }

    @Override
    protected void setJDTJavaDoc(Javadoc javaDoc) {
        this.body.setJavadoc(javaDoc);
    }
}

