/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.JavaUnit;

public class JavaUnitImpl
implements JavaUnit {
    private final List<JavaType<?>> declaredTypes;

    public JavaUnitImpl(List<JavaType<?>> declaredTypes) {
        if (Objects.requireNonNull(declaredTypes).isEmpty()) {
            throw new IllegalStateException("Declared types should not be empty");
        }
        this.declaredTypes = Collections.unmodifiableList(declaredTypes);
    }

    public JavaType<?> getGoverningType() {
        return this.declaredTypes.get(0);
    }

    public List<JavaType<?>> getTopLevelTypes() {
        return this.declaredTypes;
    }

    public String toString() {
        return this.getGoverningType().toString();
    }

    public String toUnformattedString() {
        return this.getGoverningType().toUnformattedString();
    }
}

