/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Properties;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.JavaCore;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.ToolFactory;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.formatter.CodeFormatter;
import org.jboss.forge.roaster._shade.org.eclipse.jface.text.BadLocationException;
import org.jboss.forge.roaster._shade.org.eclipse.jface.text.Document;
import org.jboss.forge.roaster._shade.org.eclipse.text.edits.TextEdit;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.util.FormatterException;
import org.jboss.forge.roaster.model.util.FormatterProfileReader;
import org.jboss.forge.roaster.model.util.JDTOptions;

public abstract class Formatter {
    public static void format(File source) throws IOException {
        Formatter.format(null, source);
    }

    public static void format(File prefs, File source) throws IOException {
        Properties options = Formatter.readConfig(prefs);
        if (options == null) {
            options = Formatter.readConfigInternal();
        }
        String content = new String(Files.readAllBytes(source.toPath()));
        String formatted = Formatter.format(options, content);
        Files.write(source.toPath(), formatted.getBytes(), new OpenOption[0]);
    }

    public static String format(JavaClassSource javaClass) {
        return Formatter.format(javaClass.toString());
    }

    public static String format(Properties prefs, JavaClassSource javaClass) {
        return Formatter.format(prefs, javaClass.toString());
    }

    public static String format(String source) {
        Properties options = Formatter.readConfigInternal();
        return Formatter.format(options, source);
    }

    public static String format(Properties prefs, String source) {
        prefs.remove("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.javaFormatter");
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter(prefs);
        Document doc = new Document(source);
        try {
            TextEdit edit = codeFormatter.format(4104, source, 0, source.length(), 0, System.lineSeparator());
            if (edit == null) {
                throw new FormatterException(source, null);
            }
            edit.apply(doc);
        }
        catch (BadLocationException e) {
            throw new FormatterException(source, e);
        }
        return doc.get();
    }

    private static Properties readConfig(File prefs) throws IOException {
        if (prefs != null) {
            Properties properties;
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(prefs));
            try {
                Properties config = prefs.getName().toLowerCase().endsWith(".xml") ? Formatter.parseXmlConfig(stream) : Formatter.parseConfig(stream);
                properties = Formatter.applyShadedPackageName(config);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IOException("Error reading preferences file: [" + prefs.getAbsolutePath() + "]", e);
                }
            }
            ((InputStream)stream).close();
            return properties;
        }
        return null;
    }

    public static Properties applyShadedPackageName(Properties config) {
        Properties modified = new Properties();
        String shadePackage = JavaCore.class.getPackage().getName().replaceAll("org\\.eclipse.*$", "");
        for (String property : config.stringPropertyNames()) {
            if (property.startsWith(shadePackage)) {
                modified.put(property, config.getProperty(property));
                continue;
            }
            modified.put(shadePackage + property, config.getProperty(property));
        }
        return modified;
    }

    private static Properties readConfigInternal() {
        Properties properties = new Properties();
        properties.setProperty("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.source", JDTOptions.getOption("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.source"));
        properties.setProperty("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.compliance", JDTOptions.getOption("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.compliance"));
        properties.setProperty("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.codegen.targetPlatform", JDTOptions.getOption("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.codegen.targetPlatform"));
        properties.setProperty("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.formatter.blank_lines_after_imports", "1");
        return properties;
    }

    private static Properties parseConfig(InputStream stream) throws IOException {
        Properties formatterOptions = Formatter.readConfigInternal();
        formatterOptions.load(stream);
        return formatterOptions;
    }

    private static Properties parseXmlConfig(InputStream stream) throws IOException {
        Properties properties = Formatter.readConfigInternal();
        Properties defaultProperties = FormatterProfileReader.fromEclipseXml((InputStream)stream).getDefaultProperties();
        properties.putAll((Map<?, ?>)defaultProperties);
        return properties;
    }
}

