/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.spi;

import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.roaster.ParserException;
import org.jboss.forge.roaster.Problem;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTParser;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.EnumDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.PackageDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.RecordDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TypeDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.util.CodeSnippetParsingUtil;
import org.jboss.forge.roaster._shade.org.eclipse.jface.text.Document;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.JavaUnit;
import org.jboss.forge.roaster.model.ast.TypeDeclarationFinderVisitor;
import org.jboss.forge.roaster.model.impl.JavaAnnotationImpl;
import org.jboss.forge.roaster.model.impl.JavaClassImpl;
import org.jboss.forge.roaster.model.impl.JavaEnumImpl;
import org.jboss.forge.roaster.model.impl.JavaInterfaceImpl;
import org.jboss.forge.roaster.model.impl.JavaPackageInfoImpl;
import org.jboss.forge.roaster.model.impl.JavaRecordImpl;
import org.jboss.forge.roaster.model.impl.JavaUnitImpl;
import org.jboss.forge.roaster.model.source.JavaAnnotationSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaEnumSource;
import org.jboss.forge.roaster.model.source.JavaInterfaceSource;
import org.jboss.forge.roaster.model.source.JavaPackageInfoSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.util.JDTOptions;
import org.jboss.forge.roaster.spi.JavaParser;

public class JavaParserImpl
implements JavaParser {
    public JavaUnit parseUnit(String data) {
        Document document = new Document(data);
        ASTParser parser = ASTParser.newParser(15);
        parser.setSource(document.get().toCharArray());
        parser.setCompilerOptions(JDTOptions.getJDTOptions());
        parser.setResolveBindings(true);
        parser.setKind(8);
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        unit.recordModifications();
        TypeDeclarationFinderVisitor visitor = new TypeDeclarationFinderVisitor();
        unit.accept(visitor);
        List<AbstractTypeDeclaration> declarations = visitor.getTypeDeclarations();
        ArrayList types = new ArrayList();
        if (!declarations.isEmpty()) {
            for (AbstractTypeDeclaration declaration : declarations) {
                if (!declaration.isPackageMemberTypeDeclaration()) continue;
                types.add((JavaType<?>)JavaParserImpl.getJavaSource(null, document, unit, declaration));
            }
            return new JavaUnitImpl(types);
        }
        if (visitor.getPackageDeclaration() != null) {
            types.add((JavaType<?>)JavaParserImpl.getJavaSource(null, document, unit, visitor.getPackageDeclaration()));
            return new JavaUnitImpl(types);
        }
        throw new ParserException("Could not find type declaration in Java source - is this actually code?");
    }

    public static JavaSource<?> getJavaSource(JavaSource<?> enclosingType, Document document, CompilationUnit unit, ASTNode declaration) {
        if (declaration instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)declaration;
            if (typeDeclaration.isInterface()) {
                return new JavaInterfaceImpl(enclosingType, document, unit, typeDeclaration);
            }
            return new JavaClassImpl(enclosingType, document, unit, typeDeclaration);
        }
        if (declaration instanceof EnumDeclaration) {
            EnumDeclaration enumDeclaration = (EnumDeclaration)declaration;
            return new JavaEnumImpl(enclosingType, document, unit, enumDeclaration);
        }
        if (declaration instanceof AnnotationTypeDeclaration) {
            AnnotationTypeDeclaration annotationTypeDeclaration = (AnnotationTypeDeclaration)declaration;
            return new JavaAnnotationImpl(enclosingType, document, unit, annotationTypeDeclaration);
        }
        if (declaration instanceof PackageDeclaration) {
            PackageDeclaration packageDeclaration = (PackageDeclaration)declaration;
            return new JavaPackageInfoImpl(enclosingType, document, unit, packageDeclaration);
        }
        if (declaration instanceof RecordDeclaration) {
            RecordDeclaration recordDeclaration = (RecordDeclaration)declaration;
            return new JavaRecordImpl(enclosingType, document, unit, recordDeclaration);
        }
        throw new ParserException("Unknown Java source type [" + declaration + "]");
    }

    public <T extends JavaSource<?>> T create(Class<T> type) {
        if (type.isAssignableFrom(JavaClassSource.class)) {
            return (T)((JavaSource)this.parseUnit("public class JavaClass { }").getGoverningType());
        }
        if (type.isAssignableFrom(JavaEnumSource.class)) {
            return (T)((JavaSource)this.parseUnit("public enum JavaEnum { }").getGoverningType());
        }
        if (type.isAssignableFrom(JavaAnnotationSource.class)) {
            return (T)((JavaSource)this.parseUnit("public @interface JavaAnnotation { }").getGoverningType());
        }
        if (type.isAssignableFrom(JavaInterfaceSource.class)) {
            return (T)((JavaSource)this.parseUnit("public interface JavaInterface { }").getGoverningType());
        }
        if (type.isAssignableFrom(JavaPackageInfoSource.class)) {
            return (T)((JavaSource)this.parseUnit("package org.example;").getGoverningType());
        }
        return null;
    }

    public List<Problem> validateSnippet(String snippet) {
        CodeSnippetParsingUtil codeSnippetParsingUtil = new CodeSnippetParsingUtil(false);
        ConstructorDeclaration constructorDeclaration = codeSnippetParsingUtil.parseStatements(snippet.toCharArray(), 0, snippet.length(), JDTOptions.getJDTOptions(), true, false);
        CompilationResult compilationResult = constructorDeclaration.compilationResult();
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (compilationResult.hasErrors()) {
            for (CategorizedProblem problem : compilationResult.getErrors()) {
                Problem p = new Problem(problem.getMessage(), problem.getSourceStart(), problem.getSourceEnd(), problem.getSourceLineNumber());
                problems.add(p);
            }
        }
        return problems;
    }
}

