/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.ui.result;

import org.jboss.forge.ui.UICommand;
import org.jboss.forge.ui.result.Failed;
import org.jboss.forge.ui.result.NavigationResult;
import org.jboss.forge.ui.result.NavigationResultImpl;
import org.jboss.forge.ui.result.Result;
import org.jboss.forge.ui.result.ResultSuccess;
import org.jboss.forge.ui.result.ResultsFail;

public abstract class Results
implements Result,
Failed {
    private final String message;
    private Throwable exception;

    public static final Result success() {
        return Results.success(null);
    }

    public static final Result success(String message) {
        return new ResultSuccess(message);
    }

    public static final Result fail(String message) {
        return new ResultsFail(message);
    }

    public static final Result fail(String message, Throwable e) {
        return new ResultsFail(message, e);
    }

    public static final NavigationResult navigateTo(Class<? extends UICommand> next) {
        return Results.navigateTo(next, null);
    }

    public static final NavigationResult navigateTo(Class<? extends UICommand> next, String message) {
        if (next == null) {
            return null;
        }
        return new NavigationResultImpl(message, next);
    }

    Results(String message) {
        this.message = message;
    }

    public Results(String message, Throwable e) {
        this.message = message;
        this.exception = e;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }
}

