/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.ui.util;

import java.net.URL;
import org.jboss.forge.ui.UICommand;
import org.jboss.forge.ui.metadata.UICategory;
import org.jboss.forge.ui.metadata.UICommandMetadata;
import org.jboss.forge.ui.util.Categories;

public class Metadata
implements UICommandMetadata {
    private static String[] VALID_DOC_EXTENSIONS = new String[]{".txt.gzip", ".txt.gz", ".txt", ".asciidoc.gzip", ".asciidoc.gz", ".asciidoc"};
    private UICommandMetadataBase metadata = new UICommandMetadataBase();

    public static Metadata forCommand(Class<? extends UICommand> type) {
        return new Metadata(type);
    }

    public Metadata(Class<? extends UICommand> type) {
        this.docLocation(this.getDocLocationFor(type)).name(type.getName()).category(Categories.create("Uncategorized"));
    }

    public Metadata name(String name) {
        this.metadata.name = name;
        return this;
    }

    public Metadata description(String description) {
        this.metadata.description = description;
        return this;
    }

    public Metadata category(UICategory category) {
        this.metadata.category = category;
        return this;
    }

    public Metadata docLocation(URL docLocation) {
        this.metadata.docLocation = docLocation;
        return this;
    }

    private URL getDocLocationFor(Class<? extends UICommand> type) {
        URL url = null;
        for (String extension : VALID_DOC_EXTENSIONS) {
            String docFileName = type.getSimpleName() + extension;
            url = type.getResource(docFileName);
            if (url != null) break;
        }
        return url;
    }

    @Override
    public String getName() {
        return this.metadata.getName();
    }

    @Override
    public String getDescription() {
        return this.metadata.getDescription();
    }

    @Override
    public UICategory getCategory() {
        return this.metadata.getCategory();
    }

    @Override
    public URL getDocLocation() {
        return this.metadata.getDocLocation();
    }

    static class UICommandMetadataBase
    implements UICommandMetadata {
        protected String name;
        protected String description;
        protected UICategory category;
        protected URL docLocation;

        UICommandMetadataBase() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public UICategory getCategory() {
            return this.category;
        }

        @Override
        public URL getDocLocation() {
            return this.docLocation;
        }
    }
}

