/*
 * Copyright 2012 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Eclipse Public License version 1.0, available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.jboss.forge.ui.context;

import java.util.HashMap;
import java.util.Map;

/**
 * This class provides a skeletal implementation of the <tt>UIContext</tt> interface, to minimize the effort required to
 * implement this interface.
 *
 * @author <a href="mailto:lincolnbaxter@gmail.com">Lincoln Baxter, III</a>
 * @author <a href="mailto:ggastald@redhat.com">George Gastaldi</a>
 */
public abstract class AbstractUIContext implements UIContext
{
   private Map<Object, Object> map = new HashMap<Object, Object>();
   private Object selection;

   @Override
   @SuppressWarnings("unchecked")
   public <SELECTIONTYPE> SELECTIONTYPE getSelection()
   {
      return (SELECTIONTYPE) selection;
   }

   @Override
   public <SELECTIONTYPE> void setSelection(SELECTIONTYPE resource)
   {
      this.selection = resource;
   }

   @Override
   public Object getAttribute(Object key)
   {
      return map.get(key);
   }

   @Override
   public Object removeAttribute(Object key)
   {
      return map.remove(key);
   }

   @Override
   public void setAttribute(Object key, Object value)
   {
      map.put(key, value);
   }
}
