/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.deployer;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.event.EventAdapterRegistry;
import org.jboss.fresh.deployer.RegistryNamingBinder;
import org.jboss.fresh.deployer.ScriptingCentral;
import org.jboss.fresh.deployer.ScriptingServiceMBean;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ScriptingService
extends RegistryNamingBinder
implements ScriptingServiceMBean {
    private String cfgPath;
    private List langs = new LinkedList();
    private List languages = new LinkedList();

    public String getName() {
        return "Scripting Services";
    }

    public void setConfigPath(String val) {
        this.cfgPath = val;
    }

    public String getConfigPath() {
        return this.cfgPath;
    }

    public void doStart() throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        InputStream in = null;
        if (this.cfgPath != null) {
            in = new FileInputStream(this.cfgPath);
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL url = cl.getResource("fresh-scripting.xml");
            if (url != null) {
                in = url.openStream();
            }
        }
        parser.parse(in, new DefaultHandler(){
            int level = 0;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
                if (this.level == 1) {
                    if (qName.equals("provider")) {
                        String clazz = null;
                        String lang = null;
                        String ext = null;
                        int len = attrs.getLength();
                        for (int i = 0; i < len; ++i) {
                            String aname = attrs.getQName(i);
                            String val = attrs.getValue(i);
                            if (aname.equals("language")) {
                                lang = val;
                                continue;
                            }
                            if (aname.equals("ext")) {
                                ext = val;
                                continue;
                            }
                            if (!aname.equals("class")) throw new SAXException("Element provider does not support attribute: " + aname);
                            clazz = val;
                        }
                        ScriptingService.this.addProvider(lang, ext, clazz);
                    } else {
                        if (!qName.equals("event-adapter")) throw new SAXException("Unknown element: " + qName);
                        String listener = null;
                        String adapter = null;
                        int len = attrs.getLength();
                        for (int i = 0; i < len; ++i) {
                            String aname = attrs.getQName(i);
                            String val = attrs.getValue(i);
                            if (aname.equals("listener-class")) {
                                listener = val;
                                continue;
                            }
                            if (!aname.equals("adapter-class")) throw new SAXException("Element event-adapter does not support attribute: " + aname);
                            adapter = val;
                        }
                        ScriptingService.this.registerEventAdapter(listener, adapter);
                    }
                } else if (this.level == 0 && !qName.equals("scripting")) {
                    throw new SAXException("Unknown element: " + qName);
                }
                ++this.level;
            }

            public void endElement(String uri, String localName, String qName) {
                --this.level;
            }
        });
        super.doStart();
    }

    public BSFManager getManager(String lang) {
        Language scriptLang = this.getLanguage(lang);
        if (scriptLang == null) {
            throw new RuntimeException("Language not supported: " + lang);
        }
        BSFManager manager = new BSFManager();
        BSFManager.registerScriptingEngine((String)scriptLang.getIdentifier(), (String)scriptLang.getScriptEngine(), (String[])scriptLang.getExtensions());
        return manager;
    }

    public void registerEventAdapter(String listenerClass, String adapterClass) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> cls1 = null;
        Class<?> cls2 = null;
        try {
            cls1 = cl.loadClass(listenerClass);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to load class: " + listenerClass, ex);
        }
        try {
            cls2 = cl.loadClass(adapterClass);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to load class: " + adapterClass, ex);
        }
        EventAdapterRegistry.register(cls1, cls2);
    }

    public void addProvider(String language, String filext, String clazz) {
        if (language == null) {
            throw new IllegalArgumentException("Language can't be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Class can't be null");
        }
        LinkedList<String> exts = new LinkedList<String>();
        if (filext != null) {
            StringTokenizer st = new StringTokenizer(filext, "; ");
            while (st.hasMoreTokens()) {
                exts.add(st.nextToken());
            }
        }
        String[] aexts = new String[exts.size()];
        Iterator it = exts.iterator();
        int i = 0;
        while (it.hasNext()) {
            aexts[i] = (String)it.next();
            ++i;
        }
        this.languages.add(new Language(language, aexts, clazz));
        this.langs.add(language);
    }

    private Language getLanguage(String lang) {
        for (Language l : this.languages) {
            if (!l.getIdentifier().equals(lang)) continue;
            return l;
        }
        return null;
    }

    public List getSupportedLanguages() {
        return new ArrayList(this.langs);
    }

    protected String getBindClass() {
        return ScriptingCentral.class.getName();
    }

    protected Object classToInstance(Class c) {
        this.setServiceObject(this);
        return this;
    }

    public boolean isLanguageSupported(String name) {
        Iterator it = new ArrayList(this.langs).iterator();
        while (it.hasNext()) {
            if (!it.next().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getLanguageForName(String name) {
        Iterator it = new ArrayList(this.langs).iterator();
        while (it.hasNext()) {
            if (!it.next().equals(name)) continue;
            return name;
        }
        return null;
    }

    public String getLanguageForExtension(String ext) {
        for (Language lng : new ArrayList(this.languages)) {
            String[] extz = lng.getExtensions();
            for (int i = 0; i < extz.length; ++i) {
                if (!extz[i].equals(ext)) continue;
                return lng.getIdentifier();
            }
        }
        return null;
    }

    protected boolean bindByReference() {
        return true;
    }

    public class Language {
        private String identifier;
        private String[] extensions;
        private String scriptEngine;

        public Language(String identifier, String[] extensions, String scriptEngine) {
            this.identifier = identifier;
            this.extensions = extensions;
            this.scriptEngine = scriptEngine;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String[] getExtensions() {
            return this.extensions;
        }

        public String getScriptEngine() {
            return this.scriptEngine;
        }
    }
}

