package org.jboss.fresh.cpii.services;

/**
 We need to implement the following abstract methods from the super class:

 init()
 activate()
 passivate()
 remove()

 those are events that we receive and we need to understand what they mean.
 */

//import org.jboss.fresh.parsek.logging.Logger;
//import org.jboss.pool.PoolEvent;
//import org.jboss.pool.PoolEventListener;
//import org.jboss.pool.PooledObject;

import org.jboss.fresh.pool.pool.Pool;
import org.jboss.fresh.pool.pool.PoolException;

public class PoolRunner {


	Thread t = null;
	private Runnable job = null;
	private Object mutex = new Object();
	private Object doneMutex = new Object();
	private Pool pool;

    private boolean mustExit = false;
    private boolean finished = false;
    private boolean autoReturn = true;

    private String name;
    
    private static volatile int tc = 0;

    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger("org.jboss.fresh.cpii.services.PoolRunner");
        
    public PoolRunner() {
    	init();
    }
    
    public PoolRunner(Pool pool) {
        if(pool==null) throw new RuntimeException("Internal error in application: pool can not be null");
        this.pool = pool;
        init();        
    }

    public void init() {
//		System.out.println("Init " + this);
        // open connection to the server, create new thread...
        t = new Thread() {
            public void run() {
                try {
                while (t != null) {
                    try {
                        // run to the point then stop - call this a starting point. Continue 					// running when we get activated, then pause running when we get
                        // passivated - return to the starting point.

                        if(mustExit) break;

                        synchronized (mutex) {
                            if (job == null) {
						//System.out.println("        [PooledRunner] Going to sleep - job = " + job + " - " + PoolRunner.this);
                                mutex.wait(); // go sleep until there is a job for us
                        //System.out.println("        [PooledRunner] Woke up - job = " + job + " - " + PoolRunner.this);        
                            } else {
//						System.out.println("Failed to go to sleep.");
                            }
                        }

                        if(mustExit) break;

                        if (job == null) continue;


                        try {
//System.out.println("  PoolRunner.run()  BEFORE job.run - " + PoolRunner.this);
                            job.run();
//System.out.println("  PoolRunner.run()  AFTER job.run - " + PoolRunner.this);
                        } catch (Throwable t) {
                            t.printStackTrace();
                        }
//System.out.println("  set JOB = NULL");
                        job = null;

                        if(autoReturn && pool != null)
                        	pool.checkin(PoolRunner.this);
                        
                        synchronized (doneMutex) {
                            doneMutex.notify();  // This one to release join
                        }

                    } catch (Throwable t) { // we should not get any exception really
                        t.printStackTrace();
                    }

                }
		} finally {
			finished = true;
		}
                // when we get finish return from the method
//				System.out.println("*** Thread finished");
            }
        };
        t.setName("Pool runner thread - " + tc++);
        t.start();
    }

    public void activate() {
        // we are about to be used, we can log something, acquire a logger, I don't know...
        // we can't use this to set runner, since it takes no parameter.
		//System.out.println("Activate " + this);
        job = null;
    }


    // what if someone runs us and then returns us to the pool without joinJob
    // we get chaos. If we are not available but are running a job, we should not let be returned
    // to the pool. Should we attempt to return ourselves to the pool?
    // in our case that would be a desirable behaviour.
    protected boolean canRemove() {
        return (job == null);
    }


    public void passivate() {
        // we are being returned to the pool, we can release some things
        // can we use this to unset runner or signal the thread to stop?
		//System.out.println("Passivate " + this);
        job = null;
    }




    public void stop() {
        job = null;
        mustExit = true;
        synchronized (mutex) {
            mutex.notify();
        }
    }

    public void destroy() {
	stop();
log.error("interrupting ...");        
        t.interrupt();
        
    }

    public void masacre() {
		destroy();
		// this method throws java.lang.NoSuchMethodError as of jdk1.5.0
		//t.destroy();
		if(!t.isDaemon()) {
			try {
				t.setDaemon(true);
			} catch(IllegalThreadStateException ex) {
			}
		}
    }


    public boolean isFinished() {
	return finished;
    }


    public void runJob(Runnable r, String name) throws IllegalStateException {
        // job smemo nastaviti samo v primeru, da smo sve�i iz poola in �e nimamo nastavljenega
        // joba

    	if (job != null)
            throw new IllegalStateException("Job has already been set for this run.");

        setName(name);

        synchronized (mutex) {
            if (job != null)
                throw new IllegalStateException("Job has already been set for this run.");
            //System.out.println("        1  job = " + job + " - " + this);
            job = r;
//			System.out.println("[PooledRunner] Job set");
            //System.out.println("        2  job = " + job);
            mutex.notify();
//			System.out.println("[PooledRunner] Notified.");
            //System.out.println("        3");
        }

    }


    public void joinJob(Runnable r, String name, long millis) throws IllegalStateException {
        synchronized (doneMutex) {
            runJob(r, name);
            try {
                doneMutex.wait(millis);
            } catch (InterruptedException ex) {
                throw new RuntimeException("This thread has been interrupted");
            }
        }
    }

    public void joinJob(Runnable r, String name) throws IllegalStateException {
        joinJob(r, name, 0);
    }


    // hmm rabili bi �e joinJob - run and wait until finished

    public Runnable getJob() {
        return job;
    }

    // Use this method before you call
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    /**
     * 
     * PoolAutoreturn is true by default. You would only want to set it to false if you want to
     * process several jobs consecutively with one checkout. In this case there are a few rules to follow.
     * You only use joinJob method so that all the execution is synchronized - we make sure there is no
     * outstanding execution after the method returns. You can only use runJob (async execution as the last one, 
     * but you have to switch to PoolAutoReturn before invoking it)
     * 
     * If you only use joinJob
     * 
     * PoolRunner runner = pool.checkout();
     * runner.setPoolAutoReturn(false);
     * try {
     *     runner.joinJob(job, "Test run 1");
     *     runner.joinJob(job2, "Test run 2");
     * } finally {
     *     runner.returnToPool();
     * }
     * 
     * 
     * 
     * if you use runJob as the last one
     *			 it's a tricky thing. A part of you wants to use returnToPool() in finally
				 But you shouldn't because it's only to be used in combination
				 with joinJob() - if you use runJob() you have to set
				 autoreturn to true before running runJob to make it be
				 returned to pool afterwards
				 if exception occurs - it's due to our error - but in this case
				 runner won't be returned to pool so we have to do it explicitly

     * PoolRunner runner = pool.checkout();
     * runner.setPoolAutoReturn(false);
     * try {
     *     runner.joinJob(job, "Test run 1");
     *     
     *     runner.setPoolAutoReturn(true);
     *     runner.runJob(job2, "Test run 2");
     * } catch(Throwable th) {
     *     runner.returnToPool();
     *     throw th;
     * }
     * 
     * */
    public void setPoolAutoReturn(boolean val) {
    	autoReturn = val;
    }
    
    public void returnToPool() throws PoolException {
    	if(pool == null)
    		throw new RuntimeException("This pool runner has no pool!");
    	pool.checkin(this);
    }
}
