package org.jboss.fresh.cpii.services;

//import org.jboss.pool.ObjectPool;
//import org.jboss.pool.PoolObjectFactory;
import org.jboss.fresh.pool.pool.PoolFactory;
import org.jboss.fresh.pool.pool.Pool;

import java.util.Iterator;

public class PoolRunnerFactory implements PoolFactory {

	private Pool pool;


	public PoolRunnerFactory() {
        	super();
	}


	/**
	 *  Called once when this <code>PoolFactory</code> instance is installed on the pool - when pool is created.
	 */
	public void registerPool(Pool p) {
		this.pool = p;
	}


	/**
	 *  Called once when this <code>PoolFactory</code> instance is uninstalled from the pool - when pool is destroyed.
	 */
	public void unregisterPool() {
		pool = null;
	}


	/**
	 *  Pool requests us to create a new instance of the pooled resource
	 */
	public Object createObject() {
        	return new PoolRunner(pool);
	}


	/**
	 *  Pool requests us to do all cleanup of object specific data for the object being deleted from the pool.
	 */
	public void deleteObject(Object o) {
		((PoolRunner) o).destroy();
	}


	/**
	 *  Pool informs us that the object is about to be checked out from the pool. We can reinitialize it...
	 */
	public void retrieveObject(Object o) {
	}


	/**
	 *  Pool informs us that the object has been returned to the pool. We can cleanup any active state - reinit it.
	 */
	public void returnObject(Object o) {
	        ((PoolRunner) o).passivate();
	}


	/**
	 *  Pool tells us that these are objects still checked out while shutting down so we need to tell them to stop or kill them
	 */
	public void killObjects(java.util.Set set) {
		Iterator it = set.iterator();
		while(it.hasNext()) {
			((PoolRunner)it.next()).stop();
		}
		
		for(int i=0; i<5 && set.size()>0; i++) {
			it = set.iterator();
			while(it.hasNext()) {
				PoolRunner pr = (PoolRunner)it.next();
				if(pr.isFinished()) it.remove();
			}
			
			try {
				Thread.sleep(1000);
			} catch(InterruptedException ex) {}
		}


		it = set.iterator();
		while(it.hasNext()) {
			((PoolRunner)it.next()).destroy();
		}

		for(int i=0; i<5 && set.size()>0; i++) {
			it = set.iterator();
			while(it.hasNext()) {
				PoolRunner pr = (PoolRunner)it.next();
				if(pr.isFinished()) it.remove();
			}
			
			try {
				Thread.sleep(1000);
			} catch(InterruptedException ex) {}
		}

		it = set.iterator();
		while(it.hasNext()) {
			((PoolRunner)it.next()).masacre();
		}

	}
	

	public Object recycleObject(Object o, Object extra) {
		deleteObject(o);
		return createObject();
	}
}
