package org.jboss.fresh.cpii.services;

import java.io.PrintWriter;


/**
 * @author strukelj
 * @version $Revision$
 * @created 2005.8.8, 12:31:05
 * @date $Date$
 * @source $Source$
 * @modified $Author$
 */
public class PoolRunnerInspector {
    public static final String VERSION = "$Header$";
    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(PoolRunnerInspector.class);


    public void dump(PoolRunner runner, PrintWriter out) {
        StackTraceElement [] trace = runner.t.getStackTrace();
        if(trace == null || trace.length == 0) {
            log(out, "No stack trace - thread is not running: " + runner);
        } else {
            StringBuilder sb = new StringBuilder("Stack trace for runner: " + runner + " thread: " + runner.t + " (State: " + runner.t.getState() + (runner.t.isInterrupted() ? ", INTERRUPTED" : "") + ")");
            for(int i=0; i<trace.length; i++) {
                sb.append("\r\n\t").append(String.valueOf(trace[i]));
            }
            sb.append("\r\n");
            log(out, sb.toString());
        }
    }

    private void log(PrintWriter out, String str) {
        if(out == null)
            log.info(str);
        else
            out.println(str);
    }

    public void dumpPool() {

    }
}
