package org.jboss.fresh.pool.pool.impl;

import org.jboss.fresh.cpii.services.PoolRunner;
import org.jboss.fresh.cpii.services.PoolRunnerInspector;

import java.util.List;
import java.util.Iterator;
import java.io.PrintWriter;

/**
 * @author strukelj
 * @version $Revision$
 * @created 2005.8.8, 12:47:55
 * @date $Date$
 * @source $Source$
 * @modified $Author$
 */
public class PoolInspector {
    public static final String VERSION = "$Header$";
    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(PoolInspector.class);

    public void inspectRunnerPool(PoolImpl pool, PrintWriter out) {
        Object [] ret = pool.getCheckedInAndCheckedOut();

        List used = (List) ret[0];
        List available = (List) ret[1];

        log(out, "Available threads: " + available.size());
        PoolRunnerInspector pis = new PoolRunnerInspector();
        Iterator it = available.iterator();
        while(it.hasNext()) {
            PoolRunner runner = (PoolRunner) it.next();
            pis.dump(runner, out);
        }

        log(out, "Threads in use: " + used.size());
        it = used.iterator();
        while(it.hasNext()) {
            PoolRunner runner = (PoolRunner) it.next();
            pis.dump(runner, out);
        }
    }

    private void log(PrintWriter out, String str) {
        if(out == null)
            log.info(str);
        else
            out.println(str);
    }

}
