/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.cpii.services;

import org.apache.log4j.Logger;
import org.jboss.fresh.pool.pool.Pool;
import org.jboss.fresh.pool.pool.PoolException;

public class PoolRunner {
    Thread t = null;
    private Runnable job = null;
    private Object mutex = new Object();
    private Object doneMutex = new Object();
    private Pool pool;
    private boolean mustExit = false;
    private boolean finished = false;
    private boolean autoReturn = true;
    private String name;
    private static volatile int tc = 0;
    private static final Logger log = Logger.getLogger((String)"org.jboss.fresh.cpii.services.PoolRunner");

    public PoolRunner() {
        this.init();
    }

    public PoolRunner(Pool pool) {
        if (pool == null) {
            throw new RuntimeException("Internal error in application: pool can not be null");
        }
        this.pool = pool;
        this.init();
    }

    public void init() {
        this.t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    while (PoolRunner.this.t != null) {
                        try {
                            if (PoolRunner.this.mustExit) {
                                break;
                            }
                            Object object = PoolRunner.this.mutex;
                            synchronized (object) {
                                if (PoolRunner.this.job == null) {
                                    PoolRunner.this.mutex.wait();
                                }
                            }
                            if (PoolRunner.this.mustExit) {
                                break;
                            }
                            if (PoolRunner.this.job == null) continue;
                            try {
                                PoolRunner.this.job.run();
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            PoolRunner.this.job = null;
                            if (PoolRunner.this.autoReturn && PoolRunner.this.pool != null) {
                                PoolRunner.this.pool.checkin(PoolRunner.this);
                            }
                            Object t = PoolRunner.this.doneMutex;
                            synchronized (t) {
                                PoolRunner.this.doneMutex.notify();
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
                finally {
                    PoolRunner.this.finished = true;
                }
            }
        };
        this.t.setName("Pool runner thread - " + tc++);
        this.t.start();
    }

    public void activate() {
        this.job = null;
    }

    protected boolean canRemove() {
        return this.job == null;
    }

    public void passivate() {
        this.job = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.job = null;
        this.mustExit = true;
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notify();
        }
    }

    public void destroy() {
        this.stop();
        log.error((Object)"interrupting ...");
        this.t.interrupt();
    }

    public void masacre() {
        this.destroy();
        if (!this.t.isDaemon()) {
            try {
                this.t.setDaemon(true);
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJob(Runnable r, String name) throws IllegalStateException {
        if (this.job != null) {
            throw new IllegalStateException("Job has already been set for this run.");
        }
        this.setName(name);
        Object object = this.mutex;
        synchronized (object) {
            if (this.job != null) {
                throw new IllegalStateException("Job has already been set for this run.");
            }
            this.job = r;
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinJob(Runnable r, String name, long millis) throws IllegalStateException {
        Object object = this.doneMutex;
        synchronized (object) {
            this.runJob(r, name);
            try {
                this.doneMutex.wait(millis);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("This thread has been interrupted");
            }
        }
    }

    public void joinJob(Runnable r, String name) throws IllegalStateException {
        this.joinJob(r, name, 0L);
    }

    public Runnable getJob() {
        return this.job;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPoolAutoReturn(boolean val) {
        this.autoReturn = val;
    }

    public void returnToPool() throws PoolException {
        if (this.pool == null) {
            throw new RuntimeException("This pool runner has no pool!");
        }
        this.pool.checkin(this);
    }
}

