/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.cpii.services;

import java.io.PrintWriter;
import org.apache.log4j.Logger;
import org.jboss.fresh.cpii.services.PoolRunner;

public class PoolRunnerInspector {
    public static final String VERSION = "$Header$";
    private static final Logger log = Logger.getLogger(PoolRunnerInspector.class);

    public void dump(PoolRunner runner, PrintWriter out) {
        StackTraceElement[] trace = runner.t.getStackTrace();
        if (trace == null || trace.length == 0) {
            this.log(out, "No stack trace - thread is not running: " + runner);
        } else {
            StringBuilder sb = new StringBuilder("Stack trace for runner: " + runner + " thread: " + runner.t + " (State: " + (Object)((Object)runner.t.getState()) + (runner.t.isInterrupted() ? ", INTERRUPTED" : "") + ")");
            for (int i = 0; i < trace.length; ++i) {
                sb.append("\r\n\t").append(String.valueOf(trace[i]));
            }
            sb.append("\r\n");
            this.log(out, sb.toString());
        }
    }

    private void log(PrintWriter out, String str) {
        if (out == null) {
            log.info((Object)str);
        } else {
            out.println(str);
        }
    }

    public void dumpPool() {
    }
}

