/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.pool.pool.impl;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.fresh.pool.pool.IllegalPoolOperationException;
import org.jboss.fresh.pool.pool.Pool;
import org.jboss.fresh.pool.pool.PoolException;
import org.jboss.fresh.pool.pool.PoolFactory;
import org.jboss.fresh.pool.pool.PoolIsFullException;
import org.jboss.fresh.pool.pool.PoolTimeoutException;

public class PoolImpl
implements Pool {
    private static final Logger log = Logger.getLogger(PoolImpl.class);
    private String name;
    private PoolFactory factory;
    private int size = 0;
    private int minsize = 0;
    private int maxsize = 100;
    private int incr = 1;
    private boolean started = false;
    private boolean blocking = true;
    private long timeout = 30000L;
    private LinkedList checked;
    private LinkedList unchecked;

    public PoolImpl(String name, PoolFactory factory) {
        this.name = name;
        this.factory = factory;
        factory.registerPool(this);
    }

    public int getSize() {
        return this.size;
    }

    public int getMinSize() {
        return this.minsize;
    }

    public void setMinSize(int val) {
        this.minsize = val;
    }

    public int getMaxSize() {
        return this.maxsize;
    }

    public synchronized void setMaxSize(int val) {
        this.maxsize = val;
        this.notify();
    }

    public List getDiagnostics() {
        return null;
    }

    public void setIncrement(int num) {
        this.incr = num;
    }

    public void setNonBlocking(boolean val) {
        this.blocking = !val;
    }

    public void setTimeout(long millis) {
        this.timeout = millis;
    }

    private void grow(int gincr) throws PoolException {
        block7: {
            block6: {
                if (gincr <= 0) break block6;
                int max = this.maxsize - this.size;
                gincr = gincr < max ? gincr : max;
                int i = 0;
                while (i < gincr) {
                    try {
                        this.unchecked.addLast(this.factory.createObject());
                    }
                    catch (Throwable ex) {
                        throw new PoolException("Error occured while creating an object.", ex);
                    }
                    ++i;
                    ++this.size;
                }
                break block7;
            }
            if (gincr >= 0) break block7;
            int max = this.unchecked.size();
            gincr = (gincr = -gincr) < max ? gincr : max;
            int i = 0;
            while (i < gincr) {
                Object o = this.unchecked.removeFirst();
                try {
                    this.factory.deleteObject(o);
                }
                catch (Throwable ex) {
                    --this.size;
                    throw new PoolException("Error occured while deleting an object. Object was thrown out of the pool anyway: " + o, ex);
                }
                ++i;
                --this.size;
            }
        }
    }

    public synchronized Object checkout() throws PoolException, InterruptedException {
        if (!this.started) {
            throw new PoolException("Pool has been stopped.");
        }
        if (this.unchecked.size() == 0) {
            if (this.size < this.maxsize) {
                this.grow(this.incr);
            } else if (this.blocking) {
                long expires = System.currentTimeMillis() + this.timeout;
                long togo = this.timeout;
                while (togo > 0L) {
                    this.wait(togo);
                    if (!this.started) {
                        throw new PoolException("Pool has been stopped.");
                    }
                    if (this.unchecked.size() > 0) break;
                    if (this.size < this.maxsize) {
                        this.grow(this.incr);
                        break;
                    }
                    togo = expires - System.currentTimeMillis();
                    if (togo > 0L) continue;
                    throw new PoolTimeoutException("Timed out while checking out.");
                }
            } else {
                throw new PoolIsFullException("All objects are checked out and the pool is full. Can't add any more.");
            }
        }
        Object o = this.unchecked.removeLast();
        this.checked.addLast(o);
        try {
            this.factory.retrieveObject(o);
        }
        catch (Throwable ex) {
            this.unchecked.addLast(o);
            this.checked.removeLast();
            throw new PoolException("Error occured while retrieving an object: " + o, ex);
        }
        return o;
    }

    public synchronized void checkin(Object o) throws PoolException {
        if (!this.checked.remove(o)) {
            throw new IllegalPoolOperationException("Trying to return an object that is not checked out.");
        }
        try {
            this.factory.returnObject(o);
        }
        catch (Throwable ex) {
            this.checked.addLast(o);
            throw new PoolException("Error occured while returning an object: " + o, ex);
        }
        this.unchecked.addLast(o);
        if (this.size > this.maxsize) {
            this.grow(this.maxsize - this.size);
        }
        this.notify();
    }

    public Object badCheckout(Object o) throws PoolException {
        return this.badCheckout(o, null);
    }

    public synchronized Object badCheckout(Object o, Object extra) throws PoolException {
        if (!this.checked.remove(o)) {
            throw new IllegalPoolOperationException("Trying to return an object that is not checked out.");
        }
        --this.size;
        try {
            o = this.factory.recycleObject(o, extra);
        }
        catch (Throwable ex) {
            throw new PoolException("An error occured while recycling an object: " + o, ex);
        }
        this.checked.addLast(o);
        ++this.size;
        try {
            this.factory.retrieveObject(o);
        }
        catch (Throwable ex) {
            this.checked.removeLast();
            this.unchecked.addLast(o);
            throw new PoolException("Error occured while retrieving an object: " + o, ex);
        }
        return o;
    }

    public synchronized void invalidate(Object o) throws PoolException {
        if (!this.checked.remove(o)) {
            throw new IllegalPoolOperationException("Trying to return an object that is not checked out.");
        }
        --this.size;
        try {
            this.factory.deleteObject(o);
        }
        catch (Throwable ex) {
            throw new PoolException("An error occured while deleting an object: " + o, ex);
        }
    }

    public synchronized void start() throws PoolException {
        if (this.started) {
            throw new IllegalPoolOperationException("Pool has already been started.");
        }
        this.unchecked = new LinkedList();
        this.checked = new LinkedList();
        this.grow(this.minsize);
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getCheckedOutCount() {
        return this.checked.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws PoolException {
        HashSet kill = null;
        PoolImpl poolImpl = this;
        synchronized (poolImpl) {
            if (this.checked == null) {
                return;
            }
            if (this.checked.size() > 0) {
                log.warn((Object)"WARN: There are still objects checked out from the pool.");
                kill = new HashSet(this.checked);
            }
            this.grow(-this.size);
            this.started = false;
            this.unchecked = null;
            this.checked = null;
            this.notifyAll();
        }
        if (kill != null) {
            this.factory.killObjects(kill);
        }
        this.factory.unregisterPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getCheckedInAndCheckedOut() {
        PoolImpl poolImpl = this;
        synchronized (poolImpl) {
            Object[] res = new Object[]{new LinkedList(this.checked), new LinkedList(this.unchecked)};
            return res;
        }
    }
}

