package org.jboss.fresh.vfs;

import java.io.Serializable;
import java.util.*;


public class FileInfo implements Serializable {

    public final static int TYPE_FILE = 1;
    public final static int TYPE_DIR = 2;
    public final static int TYPE_LINK = 3;
    public final static char NAME_SEPARATOR = '/';

    private FileName name;
    private int type;
    private Date createDate;
    private Date lastModified;
    private long length;
    private boolean complete = true;
    private String tag;
    private String mime;
    private FileName target;
    private FileInfo extra;
    private float orderIndex;
    private HashMap attrs = new HashMap();
    private HashMap roles = new HashMap();


    /*
     public FileInfo() {
     }
    */

    public FileInfo(FileInfo fi) throws VFSException {
        this(fi.getFileName(), fi.getFileType(), fi.getLength(),
                fi.getCreateDate(), fi.getLastModified(), fi.isComplete(),
                fi.getTag());
        target = fi.getTarget();
        mime = fi.getMime();
        orderIndex = fi.getOrderIndex();
        attrs = new HashMap(fi.getAttributes());
        HashMap importRoles = fi.getRoles();
        if (importRoles != null) {
            Iterator it = importRoles.keySet().iterator();

            while (it.hasNext()) {
                String importAction = (String) it.next();
                HashSet rolesForImportAction = (HashSet) importRoles.get(
                        importAction);

                setRolesForAction(importAction,
                        new HashSet(rolesForImportAction));
            }
        }
    }


    public FileInfo(String fname) throws VFSException {
        name = new FileName(fname);
    }


    public FileInfo(String fname, int type) throws VFSException {
        name = new FileName(fname);
        this.type = type;
    }


    public FileInfo(FileName fname) throws VFSException {
        name = fname;
    }


    public FileInfo(FileName fname, int type) throws VFSException {
        this.name = fname;
        this.type = type;
    }


    public FileInfo(FileName fname, String n) throws VFSException {
        name = fname.absolutize(n);
    }


    public FileInfo(FileName fname, String n, int type) throws VFSException {
        name = fname.absolutize(n);
        this.type = type;
    }


    public FileInfo(FileName fullname, int type, long size, Date create,
                    Date lastModified, boolean complete) {
        this(fullname, type, size, create, lastModified, complete, null);
    }


    public FileInfo(FileName fullname, int type, long size, Date create,
                    Date lastModified, boolean complete, String tag) {
        name = fullname;
        this.type = type;
        this.length = size;
        createDate = create;
        this.lastModified = lastModified;
        this.complete = complete;
        this.tag = tag;
    }


    public void setFileName(FileName name) {
        this.name = name;
    }


    public void setAttributes(HashMap attrs) {
        this.attrs = attrs;
    }


    public void setCreateDate(Date date) {
        this.createDate = date;
    }


    public void setLastModified(Date date) {
        lastModified = date;
    }


    public void setLength(long length) {
        this.length = length;
    }


    public void setMime(String mime) {
        this.mime = mime;
    }


    public void setTag(String tag) {
        this.tag = tag;
    }


    public void setFileType(int val) {
        type = val;
    }


    public void setComplete(boolean complete) {
        this.complete = complete;
    }


    public void setRolesForAction(String action, HashSet set) {
        roles.put(action, set);
    }


    public void setTarget(FileName target) {
        this.target = target;
    }


    public void setOrderIndex(float newIndex) {
        orderIndex = newIndex;
    }


    public FileName getFileName() {
        return name;
    }


    public HashMap getAttributes() {
        return attrs;
    }

    // �e FS security nima nobene owner specific logike, potem tega ne rabimo.
    // public String getOwner() {
    // return owner;
    // }
    public Date getCreateDate() {
        return createDate;
    }


    public Date getLastModified() {
        return lastModified;
    }


    public Collection getActions() {
        return roles.keySet();
    }


    public long getLength() {
        return length;
    }


    public String getMime() {
        return mime;
    }


    public String getTag() {
        return tag;
    }


    public int getFileType() {
        return type;
    }


    public HashMap getRoles() {
        return roles;
    }


    public HashSet getRolesForAction(String action) {
        return (HashSet) roles.get(action);
    }

    // To je dobro vedeti.
    public boolean isComplete() {
        return complete;
    }


    public boolean isFile() {
        return type == TYPE_FILE;
    }


    public boolean isDirectory() {
        return type == TYPE_DIR;
    }


    /*
     public boolean isPackage() {
     return type==TYPE_PACKAGE;
     }
    */
    public boolean isLink() {
        return type == TYPE_LINK;
    }


    public FileName getTarget() {
        // return (String)attrs.get(VFSMeta.LINKSTO);
        return target;
    }


    public float getOrderIndex() {
        return orderIndex;
    }


    public void putExtra(FileInfo val) {
        extra = val;
    }

    public FileInfo getExtra() {
        return extra;
    }


    public String toString() {
        StringBuffer buf = new StringBuffer(200);
        buf.append("filename=");
        buf.append(name);
        buf.append(";type=");
        buf.append(type);
        buf.append(";createDate=");
        buf.append(createDate);
        buf.append(";lastModified=");
        buf.append(lastModified);
        buf.append(";length=");
        buf.append(length);
        buf.append(";complete=");
        buf.append(complete);
        buf.append(";mime=");
        buf.append(mime);
        buf.append(";target=");
        buf.append(target);
        buf.append(";attrs=");
        buf.append(attrs);
        buf.append(";roles=");
        buf.append(roles);

        return buf.toString();
    }
}

