package org.jboss.fresh.vfs;

import java.util.Collection;
import java.util.List;


/**
 *  Part of VFS that takes care of meta information pieces' persistence.
 */
public interface VFSMeta {

    /**
     *  Set the cache updater - listener that keeps the cache fresh.
     *
     * @param  updater  The cache updater.
     */
    public void setCacheUpdater(VFSMetaCacheUpdater updater);

    /**
     *  Get the cache updater;.
     *
     * @return          Wanted cache updater.
     */
    public VFSMetaCacheUpdater getCacheUpdater();

    /**
     *  Name must be valid FileName object.
     *
     * @param  name  Filename of the file to be tested for existance.
     * @return       True if file exists, false otherwise.
     */
    public boolean exists(FileName name) throws Exception;

    /**
     *  Path must be valid FileName object.
     */
    public int countChildren(FileName path) throws Exception;


    /**
     *  Path must point to existing file or dir and must not be null.
     */
    public List resolvePath(FileName path) throws Exception;


    /**
     *  Path must point to existing file or dir and must not be null.
     *
     * @param  name  Description of the Parameter
     * @return       The fileInfo value
     */
    //public FileName resolve(FileName path, int maxDepth) throws Exception;

    /**
     *  Name must point to existing file or dir and must not be null.
     *
     * @return       The fileInfo value
     */
    public FileInfo getFileInfo(FileName name) throws Exception;

    /**
     *  Name must point to existing file or dir and must not be null. Return
     *  FileInfos of all links whoose target is pointing to name.
     *
     * @return       The links value
     */
    public Collection getLinks(FileName name) throws Exception;

    /**
     *  Name must point to existing file or dir and must not be null.
     */
    public List list(FileName name) throws Exception;


    /**
     *  File must not exist and must not be null.
     */
    public void create(FileInfo file) throws Exception;

    /**
     *  File must exist and must not be null.
     */
    public void update(FileInfo file) throws Exception;

    /**
     *  Name must point to existing file or dir and must not be null.
     */
    public void remove(FileName name) throws Exception;

    public void rename(FileName oldName, FileName newName) throws Exception;

    public float moveBefore(FileName file, FileName next) throws Exception;
}
