/*
 * Created on 5.12.2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.jboss.fresh.vfs.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.naming.NamingException;

import org.jboss.fresh.vfs.FileInfo;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.FileOpInfo;
import org.jboss.fresh.vfs.FileReadInfo;
import org.jboss.fresh.vfs.FileWriteInfo;
import org.jboss.fresh.vfs.NoSuchFileException;
import org.jboss.fresh.vfs.RootVFS;
import org.jboss.fresh.vfs.UserCtx;
import org.jboss.fresh.vfs.VFS;
import org.jboss.fresh.vfs.VFSAuth;
import org.jboss.fresh.vfs.VFSException;
import org.jboss.fresh.io.IOUtils;

/**
 * @author gospodar
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class DefaultRootVFS implements RootVFS, VFSAuth {

	private HashMap mounts = new LinkedHashMap();

	protected MountData findFS(FileName name) {

		while(name != null) {
			VFS vfs = (VFS) mounts.get(name.toString());
			if(vfs != null) return new MountData(name, vfs);

			if(name.size() > 0)
				name = name.getBase(name.size()-1);
			else
				name = null;
		}

		return null;
	}
	
	protected FileName translate(MountData data, FileName name) {
		return name.getSuffix(data.name.size());
	}

	protected FileName untranslate(MountData data, FileName name) {
		return data.name.absolutize(name);
	}

	/* (non-Javadoc)
	 * @see org.jboss.fresh.vfs.RootVFS#mount(java.lang.String, java.lang.String)
	 */
	public void mount(String path, VFS vfs) throws VFSException, NamingException {
		mounts.put(new FileName(path).toString(), vfs);
	}

	/* (non-Javadoc)
	 * @see org.jboss.fresh.vfs.RootVFS#unmount(java.lang.String)
	 */
	public void unmount(String path) throws VFSException {
		mounts.remove(path);
	}

	public Map listMounts() {
		return new LinkedHashMap(mounts);
	}

	/* (non-Javadoc)
	 * @see org.jboss.fresh.vfs.VFSAuth#isAuthorized(org.jboss.fresh.vfs.UserCtx, java.lang.String, org.jboss.fresh.vfs.FileInfo)
	 */
	public boolean isAuthorized(UserCtx uctx, String action, FileInfo fileinfo) {
		return false;
	}

	/* (non-Javadoc)
	 * @see org.jboss.fresh.vfs.VFS#exists(org.jboss.fresh.vfs.UserCtx, org.jboss.fresh.vfs.FileName, boolean)
	 */
	public boolean exists(UserCtx ctx, FileName name, boolean direct)
			throws VFSException {
		
		MountData dat = findFS(name); 
		if(dat == null)
			return false;

		return dat.vfs.exists(ctx, translate(dat, name), direct);
	}

	/* (non-Javadoc)
	 * @see org.jboss.fresh.vfs.VFS#getFileInfo(org.jboss.fresh.vfs.UserCtx, org.jboss.fresh.vfs.FileName, boolean)
	 */
	public FileInfo getFileInfo(UserCtx ctx, FileName name, boolean direct)
			throws VFSException {

		MountData dat = findFS(name); 
		if(dat == null)
			return null;

		FileInfo inf = dat.vfs.getFileInfo(ctx, translate(dat, name), direct);
		if(inf != null)
			inf.setFileName(untranslate(dat, inf.getFileName()));
		return inf;
	}

	/* (non-Javadoc)
	 * @see org.jboss.fresh.vfs.VFS#list(org.jboss.fresh.vfs.UserCtx, org.jboss.fresh.vfs.FileName, boolean)
	 */
	public List list(UserCtx ctx, FileName name, boolean direct)
			throws VFSException {
		MountData dat = findFS(name); 
		if(dat == null)
			return null;

		List fileLs = dat.vfs.list(ctx, translate(dat, name), direct);
		Iterator it = fileLs.iterator();
		while(it.hasNext()) {
			FileInfo inf = (FileInfo) it.next();
			if(inf != null)
				inf.setFileName(untranslate(dat, inf.getFileName()));
		}
		return fileLs;
	}

	/* (non-Javadoc)
	 * @see org.jboss.fresh.vfs.VFS#createFile(org.jboss.fresh.vfs.UserCtx, org.jboss.fresh.vfs.FileInfo)
	 */
	public String createFile(UserCtx ctx, FileInfo file) throws VFSException {
		MountData dat = findFS(file.getFileName()); 
		if(dat == null)
			return null;

		FileName untranName = file.getFileName();
		file.setFileName(translate(dat, untranName));
		String tag = dat.vfs.createFile(ctx, file);
		file.setFileName(untranName);
		return tag;
	}

	/* (non-Javadoc)
	 * @see org.jboss.fresh.vfs.VFS#updateFile(org.jboss.fresh.vfs.UserCtx, org.jboss.fresh.vfs.FileInfo)
	 */
	public String updateFile(UserCtx ctx, FileInfo file) throws VFSException {
		MountData dat = findFS(file.getFileName()); 
		if(dat == null)
			return null;

		file.setFileName(translate(dat, file.getFileName()));
		return dat.vfs.updateFile(ctx, file);
	}

	/* (non-Javadoc)
	 * @see org.jboss.fresh.vfs.VFS#remove(org.jboss.fresh.vfs.UserCtx, org.jboss.fresh.vfs.FileName, boolean)
	 */
	public void remove(UserCtx ctx, FileName name, boolean direct)
			throws VFSException {
		MountData dat = findFS(name); 
		if(dat == null)
			throw new VFSException("File does not exist: " + name);

		dat.vfs.remove(ctx, translate(dat, name), direct);
	}

	/* (non-Javadoc)
	 * @see org.jboss.fresh.vfs.VFS#write(org.jboss.fresh.vfs.UserCtx, org.jboss.fresh.vfs.FileOpInfo)
	 */
	public FileWriteInfo write(UserCtx ctx, FileOpInfo info)
			throws VFSException {
		MountData dat = findFS(info.filename); 
		if(dat == null)
			return null;

		FileName untranName = info.filename;
		info.filename = translate(dat, info.filename);

		FileWriteInfo inf = dat.vfs.write(ctx, info);
		info.filename = untranName;
		return inf; 
	}

	/* (non-Javadoc)
	 * @see org.jboss.fresh.vfs.VFS#read(org.jboss.fresh.vfs.UserCtx, org.jboss.fresh.vfs.FileOpInfo)
	 */
	public FileReadInfo read(UserCtx uctx, FileOpInfo info) throws VFSException {
		MountData dat = findFS(info.filename); 
		if(dat == null)
			return null;

		FileName untranName = info.filename;
		info.filename = translate(dat, info.filename);

		FileReadInfo inf = dat.vfs.read(uctx, info);
		info.filename = untranName;
		return inf;
	}

	/* (non-Javadoc)
	 * @see org.jboss.fresh.vfs.VFS#resolve(org.jboss.fresh.vfs.UserCtx, org.jboss.fresh.vfs.FileName, boolean)
	 */
	public FileName resolve(UserCtx ctx, FileName filename, boolean partial)
			throws VFSException {

		MountData dat = findFS(filename); 
		if(dat == null)
			return filename;

		FileName name = dat.vfs.resolve(ctx, translate(dat, filename), partial);
		
		return untranslate(dat, name);
	}

	/* (non-Javadoc)
	 * @see org.jboss.fresh.vfs.VFS#getLinks(org.jboss.fresh.vfs.UserCtx, org.jboss.fresh.vfs.FileName, boolean)
	 */
	public Collection getLinks(UserCtx ctx, FileName target, boolean partial)
			throws VFSException {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.jboss.fresh.vfs.VFS#hasContent(org.jboss.fresh.vfs.UserCtx, org.jboss.fresh.vfs.FileName, boolean)
	 */
	public boolean hasContent(UserCtx ctx, FileName file, boolean direct)
			throws VFSException {

		MountData dat = findFS(file); 
		if(dat == null)
			return false;

		return dat.vfs.hasContent(ctx, translate(dat, file), direct);
	}

	/* (non-Javadoc)
	 * @see org.jboss.fresh.vfs.VFS#move(org.jboss.fresh.vfs.UserCtx, org.jboss.fresh.vfs.FileName, org.jboss.fresh.vfs.FileName, boolean)
	 */
	public void move(UserCtx ctx, FileName oldName, FileName newName,
			boolean direct) throws VFSException {
		// TODO Auto-generated method stub
		//throw new RuntimeException("Method not yet implemented");
		// tricky one - if both are inside the same mount, then delegate,
		// otherwise do the move ourselves

		MountData dat = findFS(oldName); 
		if(dat == null)
			throw new NoSuchFileException(String.valueOf(oldName));

		MountData dat2 = findFS(newName);
		if(dat2 == null) {
			throw new NoSuchFileException(String.valueOf(newName.getPath()));
		}

		if(dat == dat2) {
			dat.vfs.move(ctx, translate(dat, oldName), translate(dat, newName), direct);
		} else {
			// copy file
			oldName = translate(dat, oldName);
			newName = translate(dat2, newName);

			try {
				VFSInputStream in = null;
				try {
					SecureVFS svf = new SecureVFS(dat.vfs, ctx);
					in = new VFSInputStream(svf, oldName.toString());
					
					SecureVFS svf2 = new SecureVFS(dat2.vfs, ctx);
					VFSOutputStream out = new VFSOutputStream(svf2, newName.toString());
		
					IOUtils.copy(in, out, 30000);
					out.close();
					
					
				} finally {
					if(in!=null) try {
						in.close();
					} catch(IOException ex) {
						ex.printStackTrace();
					}
				}				
				// and delete it
			} catch(IOException ex) {
				throw new VFSException(ex);
			}

			dat.vfs.remove(ctx, oldName, direct);
		}
	}

	/* (non-Javadoc)
	 * @see org.jboss.fresh.vfs.VFS#moveBefore(org.jboss.fresh.vfs.UserCtx, org.jboss.fresh.vfs.FileName, org.jboss.fresh.vfs.FileName)
	 */
	public float moveBefore(UserCtx ctx, FileName file, FileName next)
			throws VFSException {
		// TODO Auto-generated method stub
		return 0;
	}

	
	static class MountData {
		FileName name;
		VFS vfs;

		MountData(FileName name, VFS vfs) {
			this.name = name;
			this.vfs = vfs;
		}
	}
}
