package org.jboss.fresh.vfs.impl;

import org.jboss.fresh.vfs.*;

import java.util.Collection;
import java.util.List;

public class SecureVFS {

    VFS vfs;
    UserCtx uctx;

    public SecureVFS(VFS vfs, UserCtx uctx) {
        this.vfs = vfs;
        this.uctx = uctx;
    }

    public boolean exists(FileName name, boolean direct) throws VFSException {
        return vfs.exists(uctx, name, direct);
    }


    /** Name must not be null. If exception is occured, it indicates meta persistence problem
     *	or security restrictions. If name represent link, then target FileInfo object is also returned, in
     *	extra field.
     *  Returns valid Collection object with path resolution thread paths. It is empty only when name was root.
     *  If name does not exist (only parent or grand-parent does), it returns partial resolution (as much as it gets).
     */
/*	public List resolvePath(FileName name) throws VFSException {
		return vfs.resolvePath(uctx, name);
	}*/


    /** Name must not be null. If exception is occured, it indicates meta persistence
     *	problem or security restrictions.
     *  Returns valid fully loaded FileInfo object. If object doesn't exist, returns null.
     */
    public FileInfo getFileInfo(FileName name, boolean direct) throws VFSException {
        return vfs.getFileInfo(uctx, name, direct);
    }


    /** Name must not be null and must exist. If exception is occured, it indicates meta persistence problem
     *	or security restrictions.
     *  Returns valid Collection object filled with child FileInfo objects. FileInfos of type link have extra
     *	target FileInfo included.
     */
    public List list(FileName name, boolean direct) throws VFSException {
        return vfs.list(uctx, name, direct);
    }


    /** File must not be null and must not exist. Only name, type and mime must be specified. Optional can be specified
     *	also linkto, attributes and roles. CreateDate, lastModified, length, isComplete, tag and orderindex are set by vfs.
     *	If exception is occured, it indicates meta persistence problem or security restrictions.
     *  Returns tag string for this file.
     */
    public String createFile(FileInfo file) throws VFSException {
        return vfs.createFile(uctx, file);
    }


    /** File must not be null and must exist. Everything except name (&parent&path) will not be updated.
     *	If exception is occured, it indicates meta persistence problem or security restrictions.
     */
    public String updateFile(FileInfo file) throws VFSException {
        return vfs.updateFile(uctx, file);
    }


    /** File must not be null and must exist. File meta infos and file's content will be permanently
     *	removed. If exception is occured, it indicates persistence problem or security restrictions
     *	or that file doesn't exist.
     */
    public void remove(FileName name, boolean direct) throws VFSException {
        vfs.remove(uctx, name, direct);
    }


    /** FileOpInfo must be filled with tag, filename (file must exist), buf and complete.
     *	If exception is occured, it indicates persistence problem or security restrictions.
     *  Returns FileWriteInfo filled with new tag.
     */
    public FileWriteInfo write(FileOpInfo info) throws VFSException {
        return vfs.write(uctx, info);
    }


    /** FileOpInfo must be filled with tag (not mandatory if offset is 0), filename (file must exist) and offset.
     *	If exception is occured, it indicates persistence problem or security restrictions.
     *  Returns FileReadInfo filled with buffer, length and information if there are any more records available for this file.
     */
    public FileReadInfo read(FileOpInfo info) throws VFSException {
        return vfs.read(uctx, info);
    }


//	This method means optimization, which is optional and can be implemented in the future;
//	public void copy(UserCtx uctx, FileName name1, FileName name2) throws VFSException;

    public FileName resolve(FileName filename, boolean partial) throws VFSException {
        return vfs.resolve(uctx, filename, partial);
    }

    public Collection getLinks(FileName target, boolean partial) throws VFSException {
        return vfs.getLinks(uctx, target, partial);
    }


}