package org.jboss.fresh.vfs.impl;

import org.jboss.fresh.vfs.UserCtx;

import java.security.Principal;
import java.util.HashSet;


public class UserCtxImpl implements UserCtx {

    Principal name;
    HashSet roles;

    public UserCtxImpl(String uname, HashSet roles) {
        this.name = new Prince(uname);
        this.roles = roles;
    }


    public boolean isUserInRole(String role) {
        return roles.contains(role);
    }

    public String getLogin() {
        return name.getName();
    }


    public Principal getPrincipal() {
        return name;
    }

    class Prince implements Principal {
        String name;

        Prince(String name) {
            Prince.this.name = name;
        }

        public String getName() {
            return name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Prince) {
                Prince tmp = (Prince) obj;
                if (tmp.name.equals(name)) return true;
            }

            return false;
        }

        public int hashCode() {
            return 7 * 17 + name.hashCode();
        }

        public String toString() {
            return name;
        }
    }
}