package org.jboss.fresh.vfs.impl;

import org.jboss.fresh.cpii.services.JMXProxySupport;
import org.jboss.fresh.vfs.VFS;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.UserCtx;
import org.jboss.fresh.vfs.FileInfo;
import org.jboss.fresh.vfs.VFSException;
import org.jboss.fresh.vfs.FileWriteInfo;
import org.jboss.fresh.vfs.FileOpInfo;
import org.jboss.fresh.vfs.FileReadInfo;

import java.util.Collection;
import java.util.List;


public class VFSJMXProxy extends JMXProxySupport implements VFS {

    public VFSJMXProxy(String mbeanName) {
        super(mbeanName);
    }


    public FileInfo getFileInfo(UserCtx ctx, FileName name, boolean direct) throws VFSException {
        return ((VFS) getServiceObject()).getFileInfo(ctx, name, direct);
    }

    public Collection getLinks(UserCtx uctx, FileName target, boolean partial) throws VFSException {
        return ((VFS) getServiceObject()).getLinks(uctx, target, partial);
    }

    public boolean exists(UserCtx ctx, FileName name, boolean direct) throws VFSException {
        return ((VFS) getServiceObject()).exists(ctx, name, direct);
    }

    public List list(UserCtx ctx, FileName name, boolean direct) throws VFSException {
        return ((VFS) getServiceObject()).list(ctx, name, direct);
    }

    public String createFile(UserCtx ctx, FileInfo file) throws VFSException {
        return ((VFS) getServiceObject()).createFile(ctx, file);
    }

    public String updateFile(UserCtx ctx, FileInfo file) throws VFSException {
        return ((VFS) getServiceObject()).updateFile(ctx, file);
    }

    public void remove(UserCtx uctx, FileName name, boolean direct) throws VFSException {
        ((VFS) getServiceObject()).remove(uctx, name, direct);
    }

    public FileWriteInfo write(UserCtx uctx, FileOpInfo info) throws VFSException {
        return ((VFS) getServiceObject()).write(uctx, info);
    }

    public FileReadInfo read(UserCtx uctx, FileOpInfo info) throws VFSException {
        return ((VFS) getServiceObject()).read(uctx, info);
    }

    public FileName resolve(UserCtx uctx, FileName filename, boolean partial) throws VFSException {
        return ((VFS) getServiceObject()).resolve(uctx, filename, partial);
    }

    public boolean hasContent(UserCtx uctx, FileName file, boolean direct) throws VFSException {
        return ((VFS) getServiceObject()).hasContent(uctx, file, direct);
    }

    public void move(UserCtx uctx, FileName oldPath, FileName newPath, boolean direct) throws VFSException {
        ((VFS) getServiceObject()).move(uctx, oldPath, newPath, direct);
    }

    public float moveBefore(UserCtx uctx, FileName file, FileName next) throws VFSException {
        return ((VFS) getServiceObject()).moveBefore(uctx, file, next);
    }
}

