package org.jboss.fresh.vfs.impl.disk;

import org.jboss.fresh.vfs.VFSMeta;
import org.jboss.fresh.vfs.VFSMetaFactory;

import java.util.Properties;


public class DiskVFSMetaFactory implements VFSMetaFactory {

    public VFSMeta create(Properties p) throws Exception {
        if (p == null)
            p = System.getProperties();

        String fsroot = p.getProperty("diskfs.root", "");
        if("".equals(fsroot)) throw new RuntimeException("diskfs.root property not specified - it is required.");
        VFSMeta meta = new DiskVFSMeta(fsroot);

        return meta;
    }

}