package org.jboss.fresh.vfs.impl.mem;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;


public class MemFile implements FileContent {

	private static final int BUF_SIZE = 4096;
	private int len = 0;
	private ArrayList buffers = new ArrayList();
	private byte [] BBUF = new byte[1];

	public InputStream getInputStream() {
		return new MemInputStream(this);
	}
	
	public OutputStream getOutputStream() {
		return new MemOutputStream(this);
	}

	public long getLength() {
		return len;
	}
	
	public void setLength(long len) {
		this.len = (int) len;
	}
	
/*	public long getOffset() {
		return offs;
	}
*/	
	public RAF getRAF() {
		return new RAF(this);
	}

	public void write(int pos, int val) {
		BBUF[0] = (byte) val;
		write(pos, BBUF, 0, 1);
	}

	public void write(int pos, byte [] buf, int offs, int len) {
		// we use an ordered list of byte arrays that contain 
		// file's content
		// offset - byte array
		// when someone writes if it appends to the end we just add
		// when it overwrites existing content we identify chunks and
		// throw out intermediary plus both ends allocate one big chunk 
		// to include it all copy in beginning and end and passed buffer
		// when reading just copy to passed buffer from existing
		// there are no uncovered intervals. If file size is 10M
		// bytes are filled up with zeroes.
		
		// locate chunk which contains offset
		// if such a chunk does not exist we create it. 
		// be careful to make it contiguous

		int idx = getBufferForOffset(pos);
		if(idx == -1) {
			byte [] bf = new byte[len];
			System.arraycopy(buf, offs, bf, 0, len);
			buffers.add(new ByteBuffer(pos, len, bf));

			offs += len;
			this.len += len;

		} else {
			ByteBuffer bb = (ByteBuffer) buffers.get(idx++);
			// we need to write buffer over existing buffers
			// then if we run out of buffers we add another buffer
			int inpos = pos - bb.ofs;
			int btogo = bb.buf.length - inpos;
			int avail = buf.length - offs;
			if(btogo > avail) btogo = avail;

			while(len > 0) {
				if(btogo <= 0) {
					// need a new buffer - get next one or add new one
					if(idx < buffers.size()) {
						bb = (ByteBuffer) buffers.get(idx++);
						inpos = pos - bb.ofs; // should always be 0
						btogo = bb.buf.length - inpos;
					} else {
						btogo = len > BUF_SIZE ? len : BUF_SIZE;
						bb = new ByteBuffer(pos, 0, new byte[btogo]);
						inpos = 0;
					}
				}
if(offs < 0 || offs >= buf.length) {
	System.out.println("DOUGH !!!");
} else if(inpos < 0 || inpos >= bb.buf.length) {
	System.out.println("DOUGH !!!");
} else if(btogo > (bb.buf.length - inpos)) {
	System.out.println("DOUGH !!!");
} else if(btogo > (buf.length - offs)) {
	System.out.println("DOUGH !!!");
}
				System.arraycopy(buf, offs, bb.buf, inpos, btogo);
				bb.size = btogo;
				len -= btogo;
				offs += btogo;
				pos += btogo;
				this.len += btogo;
			}
		}
	}

	public int read(int pos) {
		int rc = read(pos,BBUF, 0, 1);
		if(rc == -1) return rc;
		return (int) BBUF[0];
	}
	
	public int read(int pos, byte[] buf, int offs, int len) {
		int idx = getBufferForOffset(pos);
		if(idx == -1) return -1;

		ByteBuffer bb = (ByteBuffer) buffers.get(idx++);
		int inpos = pos - bb.ofs;
		int btogo = bb.size - inpos;

		if(btogo<=0) {
			return -1;
		}

		int oldoffs = pos;
		
		while(len > 0) {
			btogo = btogo < len ? btogo : len;
			System.arraycopy(bb.buf, inpos, buf, offs, btogo);
			len-=btogo;
			offs+=btogo;
			pos+=btogo;

			if(len > 0 && idx < buffers.size()) {
				bb = (ByteBuffer) buffers.get(idx);
				btogo = bb.size;
			} else {
				return pos - oldoffs;
			}
		}
		
		return len;
	}
	
	
	
	int getBufferForOffset(int ofs) {
		Iterator it = buffers.iterator();
		for(int i=0; it.hasNext(); i++) {
			ByteBuffer bb = (ByteBuffer) it.next();
			if(bb.ofs > ofs) {
				return i-1;
			} else if(bb.ofs == ofs) {
				return i;
			}
		}
		
		if(buffers.size() > 0) {
			int last = buffers.size()-1;
			ByteBuffer bb = (ByteBuffer)buffers.get(last);
			if(bb.size < bb.buf.length )
				return last;
		}
		
		return -1;
	}

	
	public void close() {
		//this.offs = 0;
	}

	public void truncate(long size) {
		int idx = getBufferForOffset((int) size);
		if(idx == -1) return;

		// remove all that are more than idx
		while(buffers.size() > idx+1) {
			buffers.remove(buffers.size()-1);
		}

		ByteBuffer bb = (ByteBuffer) buffers.get(idx);
		int lesize = (int) size - bb.ofs;
		bb.size = lesize;
		if(lesize > bb.buf.length) {
			// add another one so that new size really is alocated
			// I wonder if we really need that
			bb.size = bb.buf.length;
			int togo = lesize - bb.buf.length;
			byte [] buf = new byte[togo];
			bb = new ByteBuffer(bb.ofs+bb.buf.length, togo, buf);
			buffers.add(bb);
		}

		this.len = (int) size;
		// remove all above idx
		// adjust size in idx-th	
	}

/*	public long seek(long ofs) {
		// if offs is beyond end of file we seek to the end of file
		// we return current offset
		return offs;
	}
*/
	public void flush() {
		
	}


	// we use simple linear lookup to locate byte buffer with 
	// beginning offset 
	// for big files there may be many many byte buffers
	// we need a merging strategy when we reduce number of buffers
	// by allocating new bigger ones to replace many smaller ones

	static class ByteBuffer {
		int ofs;
		int size;
		byte [] buf;
		
		ByteBuffer(int off, int len, byte [] buf) {
			ofs = off;
			size = len;
			this.buf = buf;
		}
	}
}