package org.jboss.fresh.vfs.impl.mem;

import java.io.IOException;
import java.io.InputStream;

public class MemInputStream extends InputStream {

	private int mark = -1;
	int pos = 0;
	
	private FileContent fc;
	
	/**
	 * 
	 */
	public MemInputStream(FileContent fc) {
		super();
		this.fc = fc;
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#available()
	 */
	public int available() throws IOException {
		// TODO Auto-generated method stub
		return (int) fc.getLength() - pos; 
	}

	/* (non-Javadoc)
	 * @see java.io.Closeable#close()
	 */
	public void close() throws IOException {
		pos = 0;
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#mark(int)
	 */
	public synchronized void mark(int readlimit) {
		mark = pos;
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#markSupported()
	 */
	public boolean markSupported() {
		return true;
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#read(byte[], int, int)
	 */
	public int read(byte[] b, int off, int len) throws IOException {
		int rc = fc.read(pos, b, off, len);
		pos += rc;
		return rc;
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#read(byte[])
	 */
	public int read(byte[] b) throws IOException {
		int rc = fc.read(pos, b, 0, b.length);
		pos += rc;
		return rc;
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#reset()
	 */
	public synchronized void reset() throws IOException {
		if(mark != -1) pos = seek(mark);
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#skip(long)
	 */
	public long skip(long n) throws IOException {
		long skip = pos + n;
		long cpos = seek((int)skip);
		return n - (skip - cpos);
	}

	/* (non-Javadoc)
	 * @see java.io.InputStream#read()
	 */
	public int read() throws IOException {
		// TODO Auto-generated method stub
		return fc.read(pos++);
	}

	private int seek(int pos) {
		int len = (int) fc.getLength();
		if(pos > len) return len;
		return pos;
	}
}
