package org.jboss.fresh.vfs.impl.mem;

import org.jboss.fresh.vfs.VFSMeta;
import org.jboss.fresh.vfs.VFSMetaFactory;

import java.util.Properties;


public class MemVFSMetaFactory implements VFSMetaFactory {

    public VFSMeta create(Properties p) throws Exception {
        if (p == null)
            p = System.getProperties();

        String fsname = p.getProperty("memfs.name", "");
        if("".equals(fsname)) throw new RuntimeException("memfs.name property not specified - it is used to specify a required VFS name");
        VFSMeta meta = new MemVFSMeta(null, fsname);

        return meta;
    }

}