/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.VFSException;

public class FileInfo
implements Serializable {
    public static final int TYPE_FILE = 1;
    public static final int TYPE_DIR = 2;
    public static final int TYPE_LINK = 3;
    public static final char NAME_SEPARATOR = '/';
    private FileName name;
    private int type;
    private Date createDate;
    private Date lastModified;
    private long length;
    private boolean complete = true;
    private String tag;
    private String mime;
    private FileName target;
    private FileInfo extra;
    private float orderIndex;
    private HashMap attrs = new HashMap();
    private HashMap roles = new HashMap();

    public FileInfo(FileInfo fi) throws VFSException {
        this(fi.getFileName(), fi.getFileType(), fi.getLength(), fi.getCreateDate(), fi.getLastModified(), fi.isComplete(), fi.getTag());
        this.target = fi.getTarget();
        this.mime = fi.getMime();
        this.orderIndex = fi.getOrderIndex();
        this.attrs = new HashMap(fi.getAttributes());
        HashMap importRoles = fi.getRoles();
        if (importRoles != null) {
            for (String importAction : importRoles.keySet()) {
                HashSet rolesForImportAction = (HashSet)importRoles.get(importAction);
                this.setRolesForAction(importAction, new HashSet(rolesForImportAction));
            }
        }
    }

    public FileInfo(String fname) throws VFSException {
        this.name = new FileName(fname);
    }

    public FileInfo(String fname, int type) throws VFSException {
        this.name = new FileName(fname);
        this.type = type;
    }

    public FileInfo(FileName fname) throws VFSException {
        this.name = fname;
    }

    public FileInfo(FileName fname, int type) throws VFSException {
        this.name = fname;
        this.type = type;
    }

    public FileInfo(FileName fname, String n) throws VFSException {
        this.name = fname.absolutize(n);
    }

    public FileInfo(FileName fname, String n, int type) throws VFSException {
        this.name = fname.absolutize(n);
        this.type = type;
    }

    public FileInfo(FileName fullname, int type, long size, Date create, Date lastModified, boolean complete) {
        this(fullname, type, size, create, lastModified, complete, null);
    }

    public FileInfo(FileName fullname, int type, long size, Date create, Date lastModified, boolean complete, String tag) {
        this.name = fullname;
        this.type = type;
        this.length = size;
        this.createDate = create;
        this.lastModified = lastModified;
        this.complete = complete;
        this.tag = tag;
    }

    public void setFileName(FileName name) {
        this.name = name;
    }

    public void setAttributes(HashMap attrs) {
        this.attrs = attrs;
    }

    public void setCreateDate(Date date) {
        this.createDate = date;
    }

    public void setLastModified(Date date) {
        this.lastModified = date;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setMime(String mime) {
        this.mime = mime;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setFileType(int val) {
        this.type = val;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void setRolesForAction(String action, HashSet set) {
        this.roles.put(action, set);
    }

    public void setTarget(FileName target) {
        this.target = target;
    }

    public void setOrderIndex(float newIndex) {
        this.orderIndex = newIndex;
    }

    public FileName getFileName() {
        return this.name;
    }

    public HashMap getAttributes() {
        return this.attrs;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public Collection getActions() {
        return this.roles.keySet();
    }

    public long getLength() {
        return this.length;
    }

    public String getMime() {
        return this.mime;
    }

    public String getTag() {
        return this.tag;
    }

    public int getFileType() {
        return this.type;
    }

    public HashMap getRoles() {
        return this.roles;
    }

    public HashSet getRolesForAction(String action) {
        return (HashSet)this.roles.get(action);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isFile() {
        return this.type == 1;
    }

    public boolean isDirectory() {
        return this.type == 2;
    }

    public boolean isLink() {
        return this.type == 3;
    }

    public FileName getTarget() {
        return this.target;
    }

    public float getOrderIndex() {
        return this.orderIndex;
    }

    public void putExtra(FileInfo val) {
        this.extra = val;
    }

    public FileInfo getExtra() {
        return this.extra;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(200);
        buf.append("filename=");
        buf.append(this.name);
        buf.append(";type=");
        buf.append(this.type);
        buf.append(";createDate=");
        buf.append(this.createDate);
        buf.append(";lastModified=");
        buf.append(this.lastModified);
        buf.append(";length=");
        buf.append(this.length);
        buf.append(";complete=");
        buf.append(this.complete);
        buf.append(";mime=");
        buf.append(this.mime);
        buf.append(";target=");
        buf.append(this.target);
        buf.append(";attrs=");
        buf.append(this.attrs);
        buf.append(";roles=");
        buf.append(this.roles);
        return buf.toString();
    }
}

