/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.jboss.fresh.naming.PathExpression;

public class FileName
implements PathExpression,
Serializable {
    private static final char DELIM = '/';
    private static final String ROOT = Character.toString('/');
    private String name;
    private boolean absolute;
    private final LinkedList parsed;
    private final List unmodifiable;
    private int hash;

    public FileName(String name) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException("File path can't be empty.");
        }
        this.name = name;
        this.absolute = name.charAt(0) == '/';
        LinkedList<String> l = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(name, Character.toString('/'));
        int i = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() != 0) {
                this.checkPathToken(token);
                l.add(token.intern());
            }
            ++i;
        }
        this.parsed = l;
        this.unmodifiable = Collections.unmodifiableList(this.parsed);
    }

    public FileName(List l, boolean absolute) {
        Iterator it = l.iterator();
        this.parsed = new LinkedList();
        this.unmodifiable = Collections.unmodifiableList(this.parsed);
        while (it.hasNext()) {
            String token = it.next().toString();
            if (token.length() == 0) continue;
            this.parsed.add(token.intern());
        }
        this.absolute = absolute;
    }

    public void checkPathToken(String name) {
        if (name.indexOf(47) >= 0 || name.indexOf("*") >= 0 || name.indexOf("?") >= 0) {
            throw new IllegalArgumentException("Illegal character in file name (" + name + ")");
        }
    }

    public FileName absolutize(String name) {
        return this.absolutize(new FileName(name == null ? ROOT : name));
    }

    public FileName absolutize(FileName relName) {
        LinkedList<String> resultParsed = new LinkedList<String>(this.parsed);
        LinkedList relParsed = new LinkedList(relName.parsed);
        int len = relParsed.size();
        for (int i = 0; i < len; ++i) {
            String next = (String)relParsed.get(i);
            if ("..".equals(next)) {
                if (resultParsed.isEmpty()) {
                    throw new IllegalArgumentException("Attempt to go up from root.");
                }
                resultParsed.removeLast();
                continue;
            }
            if (".".equals(next)) continue;
            resultParsed.add(next);
        }
        return new FileName(resultParsed, this.absolute);
    }

    public FileName getPath() {
        FileName result = null;
        int len = this.parsed.size();
        if (len == 0) {
            result = null;
        } else if (len == 1) {
            result = this.absolute ? new FileName(ROOT) : null;
        } else {
            LinkedList path = new LinkedList(this.parsed);
            path.removeLast();
            result = new FileName(path, this.absolute);
        }
        return result;
    }

    public String getName() {
        String name = null;
        name = this.parsed.size() == 0 ? null : (String)this.parsed.getLast();
        return name;
    }

    public boolean isRoot() {
        return this.parsed.isEmpty();
    }

    public List getParsed() {
        return this.unmodifiable;
    }

    public boolean isParsedEmpty() {
        return this.parsed.isEmpty();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof FileName) {
            FileName compareTo = (FileName)obj;
            result = compareTo.isAbsolute() == this.absolute && compareTo.parsed.equals(this.parsed);
        }
        return result;
    }

    public FileName getBase(int i) {
        List base = this.parsed.subList(0, i);
        return new FileName(base, this.absolute);
    }

    public FileName getSuffix(int i) {
        List base = this.parsed.subList(i, this.parsed.size());
        return new FileName(base, this.absolute);
    }

    public int size() {
        return this.parsed.size();
    }

    public FileName relativeTo(String name) {
        return this.relativeTo(new FileName(name));
    }

    public FileName relativeTo(FileName name) {
        FileName result = null;
        if (name.isRoot()) {
            LinkedList<String> l = new LinkedList<String>(this.parsed);
            if (l.isEmpty()) {
                l.add(".");
            }
            result = new FileName(l, false);
        } else if (this.isRoot()) {
            LinkedList<String> l = new LinkedList<String>();
            Iterator it = name.iterateTokens();
            while (it.hasNext()) {
                l.add("..");
                it.next();
            }
            result = new FileName(l, false);
        } else {
            int j;
            LinkedList startPath = name.parsed;
            LinkedList endPath = this.parsed;
            LinkedList<String> l = new LinkedList<String>();
            int i = 0;
            while (true) {
                String startPathToken = null;
                String endPathToken = null;
                if (i < this.parsed.size()) {
                    startPathToken = (String)startPath.get(i);
                }
                if (i < name.parsed.size()) {
                    endPathToken = (String)endPath.get(i);
                }
                if (startPathToken == null || endPathToken == null || endPathToken != startPathToken) break;
                ++i;
            }
            for (j = i; j < endPath.size(); ++j) {
                l.add("..");
            }
            for (j = i; j < startPath.size(); ++j) {
                l.add((String)startPath.get(j));
            }
            if (l.isEmpty()) {
                l.add(".");
            }
            result = new FileName(l, false);
        }
        return result;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = 17;
            this.hash = 37 * this.hash + (this.absolute ? 1 : 0);
            int tmp = 0;
            if (this.parsed != null) {
                tmp = this.parsed.hashCode();
            }
            this.hash = 37 * this.hash + tmp;
        } else {
            int tmp0 = 17;
            tmp0 = 37 * tmp0 + (this.absolute ? 1 : 0);
            int tmp = 0;
            if (this.parsed != null) {
                tmp = this.parsed.hashCode();
            }
            if ((tmp0 = 37 * tmp0 + tmp) != this.hash) {
                throw new RuntimeException(" * * * * * * * *   BUMMER  * * * * * * * * *");
            }
        }
        return this.hash;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean isRelative() {
        return !this.absolute;
    }

    public boolean isParent(FileName parent) {
        boolean result = true;
        Iterator itParent = parent.iterateTokens();
        Iterator itChild = this.parsed.iterator();
        while (itParent.hasNext()) {
            if (itChild.hasNext() && itParent.next().equals(itChild.next())) continue;
            result = false;
            break;
        }
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.absolute) {
            buf.append('/');
        }
        Iterator it = this.parsed.iterator();
        while (it.hasNext()) {
            String pathToken = (String)it.next();
            buf.append(pathToken);
            if (!it.hasNext()) continue;
            buf.append('/');
        }
        return buf.toString();
    }

    public Iterator iterateTokens() {
        return this.unmodifiable.iterator();
    }

    public Object getFinalToken() {
        return this.getName();
    }

    public PathExpression getParentExpression() {
        return this.getPath();
    }

    public List getTokens() {
        return this.unmodifiable;
    }

    public PathExpression absolutize(Object obj) {
        return this.absolutize((String)obj);
    }
}

