/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs.impl;

import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.fresh.cache.HierarchicalCache;
import org.jboss.fresh.cache.HierarchicalCacheImpl;
import org.jboss.fresh.vfs.FileInfo;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.TagFactory;
import org.jboss.fresh.vfs.UserCtx;
import org.jboss.fresh.vfs.VFSException;
import org.jboss.fresh.vfs.VFSMeta;
import org.jboss.fresh.vfs.VFSStore;
import org.jboss.fresh.vfs.impl.DefaultVFS;
import org.jboss.fresh.vfs.impl.VFSCacheWrapper;

public class CachedDefaultVFS
extends DefaultVFS {
    public VFSCacheWrapper cache;
    private static Logger log = Logger.getLogger(CachedDefaultVFS.class);

    public CachedDefaultVFS(VFSMeta meta, VFSStore store, TagFactory tags) {
        this((HierarchicalCache)new HierarchicalCacheImpl(), meta, store, tags);
    }

    public CachedDefaultVFS(HierarchicalCache c, VFSMeta meta, VFSStore store, TagFactory tags) {
        super(meta, store, tags);
        this.cache = new VFSCacheWrapper(c);
        meta.setCacheUpdater(this.cache);
        store.setCacheUpdater(this.cache);
    }

    protected FileName resolve(FileName filename, boolean partial) throws Exception {
        List[] fromCache;
        FileName result = null;
        if (filename.toString().equals("/")) {
            return filename;
        }
        FileName parent = filename.getPath();
        String name = filename.getName();
        if (partial) {
            fromCache = this.cache.resolve(parent, true);
            if (fromCache != null) {
                result = ((FileName)fromCache[0].get(1)).absolutize(name);
            }
        } else {
            fromCache = this.cache.resolve(filename, true);
            if (fromCache != null) {
                result = (FileName)fromCache[0].get(1);
            }
        }
        if (fromCache == null) {
            result = super.resolve(filename, partial);
        }
        return result;
    }

    public void setMeta(VFSMeta meta) {
        meta.setCacheUpdater(this.cache);
        super.setMeta(meta);
    }

    public void setStore(VFSStore store) {
        store.setCacheUpdater(this.cache);
        super.setStore(store);
    }

    public FileInfo getFileInfo(UserCtx ctx, FileName name, boolean direct) throws VFSException {
        FileInfo result;
        try {
            name = this.resolve(name, direct);
            FileInfo[] fromCache = this.cache.getFileInfo(name);
            result = fromCache != null ? fromCache[0] : super.getFileInfo(ctx, name, direct);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
        return result;
    }

    public boolean exists(UserCtx ctx, FileName name, boolean direct) throws VFSException {
        boolean result;
        try {
            FileName file = this.resolve(name, direct);
            boolean[] fromCache = this.cache.exists(name);
            result = fromCache != null ? fromCache[0] : super.exists(ctx, name, direct);
        }
        catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
        return result;
    }

    public List list(UserCtx ctx, FileName name, boolean direct) throws VFSException {
        List result;
        try {
            List[] fromCache = this.cache.list(this.resolve(name, direct));
            result = fromCache != null ? fromCache[0] : super.list(ctx, name, direct);
        }
        catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
        return result;
    }

    public boolean hasContent(UserCtx uctx, FileName file, boolean direct) throws VFSException {
        boolean result;
        try {
            file = this.resolve(file, direct);
            boolean[] fromCache = this.cache.hasContent(file);
            result = fromCache != null ? fromCache[0] : super.hasContent(uctx, file, direct);
        }
        catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
        return result;
    }
}

