/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.jboss.fresh.io.IOUtils;
import org.jboss.fresh.vfs.FileInfo;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.FileOpInfo;
import org.jboss.fresh.vfs.FileReadInfo;
import org.jboss.fresh.vfs.FileWriteInfo;
import org.jboss.fresh.vfs.NoSuchFileException;
import org.jboss.fresh.vfs.RootVFS;
import org.jboss.fresh.vfs.UserCtx;
import org.jboss.fresh.vfs.VFS;
import org.jboss.fresh.vfs.VFSAuth;
import org.jboss.fresh.vfs.VFSException;
import org.jboss.fresh.vfs.impl.SecureVFS;
import org.jboss.fresh.vfs.impl.VFSInputStream;
import org.jboss.fresh.vfs.impl.VFSOutputStream;

public class DefaultRootVFS
implements RootVFS,
VFSAuth {
    private HashMap mounts = new LinkedHashMap();

    protected MountData findFS(FileName name) {
        while (name != null) {
            VFS vfs = (VFS)this.mounts.get(name.toString());
            if (vfs != null) {
                return new MountData(name, vfs);
            }
            if (name.size() > 0) {
                name = name.getBase(name.size() - 1);
                continue;
            }
            name = null;
        }
        return null;
    }

    protected FileName translate(MountData data, FileName name) {
        return name.getSuffix(data.name.size());
    }

    protected FileName untranslate(MountData data, FileName name) {
        return data.name.absolutize(name);
    }

    public void mount(String path, VFS vfs) throws VFSException, NamingException {
        this.mounts.put(new FileName(path).toString(), vfs);
    }

    public void unmount(String path) throws VFSException {
        this.mounts.remove(path);
    }

    public Map listMounts() {
        return new LinkedHashMap(this.mounts);
    }

    public boolean isAuthorized(UserCtx uctx, String action, FileInfo fileinfo) {
        return false;
    }

    public boolean exists(UserCtx ctx, FileName name, boolean direct) throws VFSException {
        MountData dat = this.findFS(name);
        if (dat == null) {
            return false;
        }
        return dat.vfs.exists(ctx, this.translate(dat, name), direct);
    }

    public FileInfo getFileInfo(UserCtx ctx, FileName name, boolean direct) throws VFSException {
        MountData dat = this.findFS(name);
        if (dat == null) {
            return null;
        }
        FileInfo inf = dat.vfs.getFileInfo(ctx, this.translate(dat, name), direct);
        if (inf != null) {
            inf.setFileName(this.untranslate(dat, inf.getFileName()));
        }
        return inf;
    }

    public List list(UserCtx ctx, FileName name, boolean direct) throws VFSException {
        MountData dat = this.findFS(name);
        if (dat == null) {
            return null;
        }
        List fileLs = dat.vfs.list(ctx, this.translate(dat, name), direct);
        for (FileInfo inf : fileLs) {
            if (inf == null) continue;
            inf.setFileName(this.untranslate(dat, inf.getFileName()));
        }
        return fileLs;
    }

    public String createFile(UserCtx ctx, FileInfo file) throws VFSException {
        MountData dat = this.findFS(file.getFileName());
        if (dat == null) {
            return null;
        }
        FileName untranName = file.getFileName();
        file.setFileName(this.translate(dat, untranName));
        String tag = dat.vfs.createFile(ctx, file);
        file.setFileName(untranName);
        return tag;
    }

    public String updateFile(UserCtx ctx, FileInfo file) throws VFSException {
        MountData dat = this.findFS(file.getFileName());
        if (dat == null) {
            return null;
        }
        file.setFileName(this.translate(dat, file.getFileName()));
        return dat.vfs.updateFile(ctx, file);
    }

    public void remove(UserCtx ctx, FileName name, boolean direct) throws VFSException {
        MountData dat = this.findFS(name);
        if (dat == null) {
            throw new VFSException("File does not exist: " + name);
        }
        dat.vfs.remove(ctx, this.translate(dat, name), direct);
    }

    public FileWriteInfo write(UserCtx ctx, FileOpInfo info) throws VFSException {
        MountData dat = this.findFS(info.filename);
        if (dat == null) {
            return null;
        }
        FileName untranName = info.filename;
        info.filename = this.translate(dat, info.filename);
        FileWriteInfo inf = dat.vfs.write(ctx, info);
        info.filename = untranName;
        return inf;
    }

    public FileReadInfo read(UserCtx uctx, FileOpInfo info) throws VFSException {
        MountData dat = this.findFS(info.filename);
        if (dat == null) {
            return null;
        }
        FileName untranName = info.filename;
        info.filename = this.translate(dat, info.filename);
        FileReadInfo inf = dat.vfs.read(uctx, info);
        info.filename = untranName;
        return inf;
    }

    public FileName resolve(UserCtx ctx, FileName filename, boolean partial) throws VFSException {
        MountData dat = this.findFS(filename);
        if (dat == null) {
            return filename;
        }
        FileName name = dat.vfs.resolve(ctx, this.translate(dat, filename), partial);
        return this.untranslate(dat, name);
    }

    public Collection getLinks(UserCtx ctx, FileName target, boolean partial) throws VFSException {
        return null;
    }

    public boolean hasContent(UserCtx ctx, FileName file, boolean direct) throws VFSException {
        MountData dat = this.findFS(file);
        if (dat == null) {
            return false;
        }
        return dat.vfs.hasContent(ctx, this.translate(dat, file), direct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(UserCtx ctx, FileName oldName, FileName newName, boolean direct) throws VFSException {
        MountData dat = this.findFS(oldName);
        if (dat == null) {
            throw new NoSuchFileException(String.valueOf(oldName));
        }
        MountData dat2 = this.findFS(newName);
        if (dat2 == null) {
            throw new NoSuchFileException(String.valueOf(newName.getPath()));
        }
        if (dat == dat2) {
            dat.vfs.move(ctx, this.translate(dat, oldName), this.translate(dat, newName), direct);
        } else {
            oldName = this.translate(dat, oldName);
            newName = this.translate(dat2, newName);
            try {
                VFSInputStream in = null;
                try {
                    SecureVFS svf = new SecureVFS(dat.vfs, ctx);
                    in = new VFSInputStream(svf, oldName.toString());
                    SecureVFS svf2 = new SecureVFS(dat2.vfs, ctx);
                    VFSOutputStream out = new VFSOutputStream(svf2, newName.toString());
                    IOUtils.copy((InputStream)in, (OutputStream)out, (int)30000);
                    out.close();
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new VFSException(ex);
            }
            dat.vfs.remove(ctx, oldName, direct);
        }
    }

    public float moveBefore(UserCtx ctx, FileName file, FileName next) throws VFSException {
        return 0.0f;
    }

    static class MountData {
        FileName name;
        VFS vfs;

        MountData(FileName name, VFS vfs) {
            this.name = name;
            this.vfs = vfs;
        }
    }
}

