/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.jboss.fresh.vfs.FileInfo;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.FileOpInfo;
import org.jboss.fresh.vfs.FileReadInfo;
import org.jboss.fresh.vfs.FileWriteInfo;
import org.jboss.fresh.vfs.NoSuchFileException;
import org.jboss.fresh.vfs.TagFactory;
import org.jboss.fresh.vfs.UserCtx;
import org.jboss.fresh.vfs.VFS;
import org.jboss.fresh.vfs.VFSAuth;
import org.jboss.fresh.vfs.VFSConfig;
import org.jboss.fresh.vfs.VFSException;
import org.jboss.fresh.vfs.VFSMeta;
import org.jboss.fresh.vfs.VFSStore;

public class DefaultVFS
implements VFS,
VFSConfig,
VFSAuth,
Serializable {
    protected VFSMeta meta;
    protected VFSStore store;
    protected TagFactory tags;

    public DefaultVFS(VFSMeta meta, VFSStore store, TagFactory tags) {
        this.meta = meta;
        this.store = store;
        this.tags = tags;
        tags.init();
    }

    public boolean isAuthorized(UserCtx uctx, String action, FileInfo fileinfo) {
        return true;
    }

    public void setMeta(VFSMeta meta) {
        this.meta = meta;
    }

    public void setStore(VFSStore store) {
        this.store = store;
    }

    public void setTagFactory(TagFactory tags) {
        this.tags = tags;
    }

    public boolean exists(UserCtx ctx, FileName name, boolean direct) throws VFSException {
        try {
            FileName file = this.resolve(name, direct);
            return this.meta.exists(file);
        }
        catch (Exception e) {
            return false;
        }
    }

    public FileInfo getFileInfo(UserCtx ctx, FileName name, boolean direct) throws VFSException {
        try {
            return this.meta.getFileInfo(this.resolve(name, direct));
        }
        catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }

    public List list(UserCtx ctx, FileName name, boolean direct) throws VFSException {
        try {
            List<FileInfo> listing;
            FileName path = null;
            path = this.resolve(name, direct);
            FileInfo parent = this.meta.getFileInfo(path);
            if (parent == null || !parent.isDirectory()) {
                listing = new LinkedList<FileInfo>();
                if (parent != null) {
                    listing.add(parent);
                }
            } else {
                listing = this.meta.list(path);
            }
            return listing;
        }
        catch (Exception e) {
            e.printStackTrace();
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }

    public String createFile(UserCtx ctx, FileInfo file) throws VFSException {
        try {
            if (this.meta.exists(file.getFileName())) {
                throw new VFSException("Attempt to create file that already exists.");
            }
            if (file.getFileName() == null || file.getMime() == null && file.isFile() || file.isLink() && file.getTarget() == null) {
                throw new VFSException("Attempt to create file with name or mime being null.");
            }
            String tag = this.tags.newTag();
            file.setFileName(this.resolve(file.getFileName(), true));
            file.setCreateDate(new Date());
            file.setLastModified(file.getCreateDate());
            file.setLength(0L);
            file.setTag(tag);
            file.setComplete(true);
            this.meta.create(file);
            return tag;
        }
        catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }

    public String updateFile(UserCtx ctx, FileInfo file) throws VFSException {
        try {
            if (!this.meta.exists(file.getFileName())) {
                throw new VFSException("Attempt to create file that already exists.");
            }
            String tag = this.tags.newTag();
            FileName path = this.resolve(file.getFileName(), true);
            file.setFileName(path);
            file.setLastModified(new Date());
            file.setTag(tag);
            this.meta.update(file);
            if (file.getLength() == 0L && this.store.hasContent(path)) {
                this.store.removeContent(path);
            }
            return tag;
        }
        catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }

    public void remove(UserCtx uctx, FileName name, boolean direct) throws VFSException {
        try {
            FileName path = this.resolve(name, direct);
            this.meta.remove(path);
            this.store.removeContent(path);
        }
        catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }

    public FileWriteInfo write(UserCtx uctx, FileOpInfo info) throws VFSException {
        try {
            String tag = this.tags.newTag();
            FileInfo file = this.meta.getFileInfo(info.filename);
            if (file == null) {
                throw new NoSuchFileException(String.valueOf(info.filename));
            }
            info.filename = file.getFileName();
            if (!info.tag.equals(file.getTag())) {
                throw new VFSException("Wrong filetag specified. Write operation not allowed.");
            }
            file.setTag(tag);
            if (info.append) {
                long oldLength = file.getLength();
                long newLength = oldLength + (long)info.buf.length;
                info.offset = oldLength;
                file.setLength(newLength);
            } else {
                file.setLength(info.buf.length);
                if (this.store.hasContent(info.filename)) {
                    this.store.removeContent(info.filename);
                }
            }
            this.store.writeContent(info);
            FileWriteInfo result = new FileWriteInfo();
            result.tag = tag;
            file.setComplete(info.complete);
            file.setLastModified(new Date());
            this.meta.update(file);
            return result;
        }
        catch (VFSException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            VFSException ve = new VFSException();
            ve.initCause(e);
            throw ve;
        }
    }

    public FileReadInfo read(UserCtx uctx, FileOpInfo info) throws VFSException {
        try {
            FileInfo file = this.meta.getFileInfo(info.filename);
            if (file == null) {
                throw new NoSuchFileException(info.filename.toString());
            }
            info.filename = file.getFileName();
            if (!this.store.hasContent(info.filename)) {
                return null;
            }
            if (info.offset != 0L && !info.tag.equals(file.getTag())) {
                throw new VFSException("Wrong filetag specified. Write operation not allowed.");
            }
            FileReadInfo result = this.store.readContent(info);
            result.tag = file.getTag();
            return result;
        }
        catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }

    public FileName resolve(UserCtx uctx, FileName filename, boolean partial) throws VFSException {
        try {
            return this.resolve(filename, partial);
        }
        catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }

    public Collection getLinks(UserCtx uctx, FileName target, boolean direct) throws VFSException {
        try {
            target = this.resolve(target, direct);
            return this.meta.getLinks(target);
        }
        catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }

    public boolean hasContent(UserCtx uctx, FileName file, boolean direct) throws VFSException {
        try {
            file = this.resolve(file, direct);
            return this.store.hasContent(file);
        }
        catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }

    public void move(UserCtx uctx, FileName oldPath, FileName newPath, boolean direct) throws VFSException {
        try {
            oldPath = this.resolve(oldPath, direct);
            newPath = this.resolve(newPath, true);
            this.meta.rename(oldPath, newPath);
            this.store.rename(oldPath, newPath);
        }
        catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }

    public float moveBefore(UserCtx uctx, FileName file, FileName next) throws VFSException {
        try {
            return this.meta.moveBefore(file, next);
        }
        catch (Exception e) {
            VFSException ve = new VFSException();
            ve.setUnderlyingThrowable(e);
            throw ve;
        }
    }

    protected FileName resolve(FileName filename, boolean partial) throws Exception {
        FileName result;
        boolean full;
        boolean bl = full = !partial;
        if (filename.toString().equals("/")) {
            return filename;
        }
        FileName parent = filename.getPath();
        String name = filename.getName();
        if (partial) {
            List l = this.meta.resolvePath(parent);
            result = ((FileName)l.get(l.size() - 1)).absolutize(name);
        } else {
            List l = this.meta.resolvePath(filename);
            result = (FileName)l.get(l.size() - 1);
        }
        return result;
    }
}

