/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs.impl;

import java.util.Collection;
import java.util.List;
import org.jboss.fresh.vfs.FileInfo;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.FileOpInfo;
import org.jboss.fresh.vfs.FileReadInfo;
import org.jboss.fresh.vfs.FileWriteInfo;
import org.jboss.fresh.vfs.UserCtx;
import org.jboss.fresh.vfs.VFS;
import org.jboss.fresh.vfs.VFSException;

public class SecureVFS {
    VFS vfs;
    UserCtx uctx;

    public SecureVFS(VFS vfs, UserCtx uctx) {
        this.vfs = vfs;
        this.uctx = uctx;
    }

    public boolean exists(FileName name, boolean direct) throws VFSException {
        return this.vfs.exists(this.uctx, name, direct);
    }

    public FileInfo getFileInfo(FileName name, boolean direct) throws VFSException {
        return this.vfs.getFileInfo(this.uctx, name, direct);
    }

    public List list(FileName name, boolean direct) throws VFSException {
        return this.vfs.list(this.uctx, name, direct);
    }

    public String createFile(FileInfo file) throws VFSException {
        return this.vfs.createFile(this.uctx, file);
    }

    public String updateFile(FileInfo file) throws VFSException {
        return this.vfs.updateFile(this.uctx, file);
    }

    public void remove(FileName name, boolean direct) throws VFSException {
        this.vfs.remove(this.uctx, name, direct);
    }

    public FileWriteInfo write(FileOpInfo info) throws VFSException {
        return this.vfs.write(this.uctx, info);
    }

    public FileReadInfo read(FileOpInfo info) throws VFSException {
        return this.vfs.read(this.uctx, info);
    }

    public FileName resolve(FileName filename, boolean partial) throws VFSException {
        return this.vfs.resolve(this.uctx, filename, partial);
    }

    public Collection getLinks(FileName target, boolean partial) throws VFSException {
        return this.vfs.getLinks(this.uctx, target, partial);
    }
}

