/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jboss.fresh.cache.HierarchicalCache;
import org.jboss.fresh.naming.PathExpression;
import org.jboss.fresh.vfs.FileInfo;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.VFSMetaCacheUpdater;
import org.jboss.fresh.vfs.VFSStoreCacheUpdater;

public class VFSCacheWrapper
implements VFSMetaCacheUpdater,
VFSStoreCacheUpdater {
    private static Logger log = Logger.getLogger((String)"org.jboss.fresh.vfs.impl.VFSCacheWrapper");
    public HierarchicalCache cache;

    public VFSCacheWrapper(HierarchicalCache cache) {
        this.cache = cache;
    }

    public void onExists(FileName pe, boolean result) {
        VFSCacheItem item = this.getCachedItem(pe);
        if (!result) {
            item.setFileInfo(null);
            item.setListComplete(false);
            item.setContent(null);
            item.setChildrenCount(null);
        }
        item.setExists(new Boolean(result));
    }

    public void onCountChildren(FileName pe, int count) {
        VFSCacheItem item = this.getCachedItem(pe);
        item.setChildrenCount(new Integer(count));
        item.setExists(new Boolean(true));
    }

    public void onGetFileInfo(FileName pe, FileInfo fileinfo) {
        VFSCacheItem item = this.getCachedItem(pe);
        item.setFileInfo(fileinfo);
        item.setExists(new Boolean(true));
    }

    public void onList(FileName pe, List links) {
        VFSCacheItem item = this.getCachedItem(pe);
        item.setListComplete(true);
        item.setExists(new Boolean(true));
        for (FileInfo fi : links) {
            this.onGetFileInfo(fi.getFileName(), fi);
        }
    }

    public void onCreate(FileInfo fi) {
        FileName pe = fi.getFileName();
        VFSCacheItem item = new VFSCacheItem();
        this.cache.put((PathExpression)pe, (Object)item);
        item.setFileInfo(fi);
        item.setExists(new Boolean(true));
        item.setChildrenCount(new Integer(0));
        item.setContent(new Boolean(false));
    }

    public void onUpdate(FileInfo fi) {
        FileName pe = fi.getFileName();
        VFSCacheItem item = this.getCachedItem(pe);
        item.setFileInfo(fi);
        item.setExists(new Boolean(true));
    }

    public void onRemove(FileName pe, boolean recursive) {
        VFSCacheItem item = (VFSCacheItem)this.cache.remove((PathExpression)pe);
    }

    public void onRename(FileName pe, FileName newpe) {
        VFSCacheItem item = (VFSCacheItem)this.cache.remove((PathExpression)pe);
        item.getFileInfo().setFileName(newpe);
        this.cache.put((PathExpression)newpe, (Object)item);
    }

    public void onMoveBefore(FileName pe, float idx) {
        VFSCacheItem item = (VFSCacheItem)this.cache.get((PathExpression)pe);
        if (item != null && item.getFileInfo() != null) {
            item.getFileInfo().setOrderIndex(idx);
        }
    }

    public void onHasContent(FileName fn, boolean result) {
        VFSCacheItem item = this.getCachedItem(fn);
        item.setContent(new Boolean(result));
    }

    public void onWriteContent(FileName fn) {
        VFSCacheItem item = this.getCachedItem(fn);
        item.setContent(new Boolean(true));
    }

    public void onRemoveContent(FileName fn) {
        VFSCacheItem item = this.getCachedItem(fn);
        item.setContent(new Boolean(false));
    }

    public void onRenameContent(FileName fn) {
        this.onRemoveContent(fn);
    }

    public List[] resolve(FileName pe, boolean faster) {
        ArrayList<FileName> res = new ArrayList<FileName>();
        List[] result = new List[]{res};
        res.add(pe);
        Iterator it = pe.iterateTokens();
        FileName path = new FileName(new Vector(), true);
        int i = 0;
        while (it.hasNext()) {
            ++i;
            Object token = it.next();
            FileInfo[] fromCache = this.getFileInfo(path = path.absolutize((String)token));
            if (fromCache == null || fromCache[0] == null) {
                boolean[] existsFromCache = this.exists(path);
                if (existsFromCache != null && !existsFromCache[0]) {
                    res.add(path);
                    break;
                }
                result = null;
                break;
            }
            FileInfo fi = fromCache[0];
            if (!fi.isLink()) continue;
            path = fi.getTarget();
            if (faster) continue;
            FileName tmp = path;
            for (int j = i; j < pe.getTokens().size(); ++j) {
                tmp.absolutize((String)pe.getTokens().get(j));
            }
            res.add(tmp);
        }
        if (faster) {
            res.add(path);
        }
        if (result != null) {
            // empty if block
        }
        return result;
    }

    public boolean[] exists(FileName pe) {
        boolean[] result = null;
        VFSCacheItem item = (VFSCacheItem)this.cache.get((PathExpression)pe);
        if (item != null && item.exists() != null) {
            result = new boolean[]{item.exists()};
        }
        return result;
    }

    public int[] countChildren(FileName pe) {
        int[] result = null;
        VFSCacheItem item = (VFSCacheItem)this.cache.get((PathExpression)pe);
        if (item != null && item.countChildren() != null) {
            result = new int[]{item.countChildren()};
        }
        return result;
    }

    public FileInfo[] getFileInfo(FileName pe) {
        FileInfo[] result = null;
        VFSCacheItem item = (VFSCacheItem)this.cache.get((PathExpression)pe);
        if (item != null && item.getFileInfo() != null) {
            result = new FileInfo[]{item.getFileInfo()};
        } else if (item != null && !item.exists().booleanValue()) {
            result = new FileInfo[]{null};
        }
        return result;
    }

    public List[] list(FileName pe) {
        List[] result = null;
        VFSCacheItem item2 = (VFSCacheItem)this.cache.get((PathExpression)pe);
        Collection c = this.cache.childrenVals((PathExpression)pe);
        if (item2 != null && item2.listComplete) {
            ArrayList<FileInfo> l = new ArrayList<FileInfo>();
            for (VFSCacheItem item2 : c) {
                if (item2.exists() == null || !item2.exists().booleanValue()) continue;
                l.add(item2.getFileInfo());
            }
            Collections.sort(l, new Comparator(){

                public int compare(Object o1, Object o2) {
                    float fnum2;
                    float fnum1 = ((FileInfo)o1).getOrderIndex();
                    if (fnum1 > (fnum2 = ((FileInfo)o2).getOrderIndex())) {
                        return 1;
                    }
                    if (fnum1 < fnum2) {
                        return -1;
                    }
                    return 0;
                }

                public boolean equals(Object o) {
                    return false;
                }
            });
            result = new List[]{l};
        }
        return result;
    }

    public boolean[] hasContent(FileName pe) {
        boolean[] result = null;
        VFSCacheItem item = (VFSCacheItem)this.cache.get((PathExpression)pe);
        if (item != null && item.getFileInfo() != null) {
            result = new boolean[]{item.hasContent()};
        }
        return result;
    }

    private VFSCacheItem getCachedItem(PathExpression pe) {
        VFSCacheItem item = (VFSCacheItem)this.cache.get(pe);
        if (item == null) {
            item = new VFSCacheItem();
            this.cache.put(pe, (Object)item);
        }
        return item;
    }

    static class VFSCacheItem
    implements Serializable {
        private FileInfo fileinfo;
        private Boolean exists;
        private boolean listComplete;
        private Boolean content;
        private Integer childrenCount;

        VFSCacheItem() {
        }

        public FileInfo getFileInfo() {
            return this.fileinfo;
        }

        public Boolean exists() {
            return this.exists;
        }

        public boolean isListComplete() {
            return this.listComplete;
        }

        public Boolean hasContent() {
            return this.content;
        }

        public Integer countChildren() {
            return this.childrenCount;
        }

        public void setFileInfo(FileInfo fi) {
            this.fileinfo = fi;
        }

        public void setExists(Boolean exists) {
            this.exists = exists;
        }

        public void setListComplete(boolean lc) {
            this.listComplete = lc;
        }

        public void setContent(Boolean con) {
            this.content = con;
        }

        public void setChildrenCount(Integer i) {
            this.childrenCount = i;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("fileinfo = " + this.fileinfo);
            buf.append("\nexists   = " + this.exists);
            buf.append("\nlistCmp  = " + this.listComplete);
            buf.append("\ncontent  = " + this.content);
            buf.append("\nchildCnt = " + this.childrenCount + "\n");
            return buf.toString();
        }
    }
}

