/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.fresh.vfs.impl;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.fresh.registry.RegistryContext;
import org.jboss.fresh.vfs.FileInfo;
import org.jboss.fresh.vfs.FileName;
import org.jboss.fresh.vfs.FileOpInfo;
import org.jboss.fresh.vfs.FileReadInfo;
import org.jboss.fresh.vfs.VFSFileHandlerFactory;
import org.jboss.fresh.vfs.impl.SecureVFS;

public class VFSInputStream
extends InputStream {
    private SecureVFS vfs;
    private int pos = 0;
    private byte[] buf;
    private FileReadInfo rinf;
    private FileOpInfo opinf;
    private boolean closed = false;
    private InputStream delegate;

    public VFSInputStream(SecureVFS vfs, String filename) throws IOException {
        this.vfs = vfs;
        this.opinf = new FileOpInfo();
        FileInfo info = vfs.getFileInfo(new FileName(filename), false);
        if (info == null) {
            throw new IOException("The specified file does not exist: " + filename);
        }
        String device = (String)info.getAttributes().get("file-handler");
        if (device != null) {
            try {
                RegistryContext ctx = new RegistryContext();
                VFSFileHandlerFactory f = (VFSFileHandlerFactory)ctx.lookup(device);
                this.delegate = f.getInputStream(info);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                IOException exout = new IOException("File handler initialization failed: ");
                exout.initCause(ex);
                throw exout;
            }
            return;
        }
        this.opinf.filename = info.getFileName();
        this.rinf = new FileReadInfo();
        this.rinf.more = true;
    }

    public int read() throws IOException {
        if (this.delegate != null) {
            return this.delegate.read();
        }
        if (this.closed) {
            return -1;
        }
        return 0;
    }

    public int read(byte[] buf) throws IOException {
        if (this.delegate != null) {
            return this.delegate.read(buf);
        }
        if (this.closed) {
            return -1;
        }
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offs, int len) throws IOException {
        if (this.delegate != null) {
            return this.delegate.read(buf, offs, len);
        }
        if (this.closed || !this.rinf.more) {
            return -1;
        }
        int cpos = offs;
        int togo = len;
        while (togo > 0 && this.rinf.more) {
            int tlen;
            if (this.rinf.buf == null) {
                this.rinf = this.vfs.read(this.opinf);
                if (this.rinf == null || this.rinf.buf == null) {
                    throw new IOException("Failed to read file from vfs: " + this.opinf.filename + " (offset:" + this.opinf.offset + ")");
                }
                this.opinf.offset += (long)this.rinf.buf.length;
                this.opinf.tag = this.rinf.tag;
                this.pos = 0;
            }
            int tc = (tlen = this.rinf.buf.length - this.pos) < togo ? tlen : togo;
            System.arraycopy(this.rinf.buf, this.pos, buf, cpos, tc);
            togo -= tc;
            cpos += tc;
            this.pos += tc;
            if (this.pos < this.rinf.buf.length) continue;
            this.rinf.buf = null;
        }
        return len - togo;
    }

    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
            return;
        }
        this.closed = true;
    }
}

